/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.registry;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.parser.FindBugsMessages;
import edu.hm.hafner.analysis.parser.FindBugsParser;
import edu.hm.hafner.analysis.registry.ParserDescriptor;
import edu.hm.hafner.analysis.util.Deferred;

class FindBugsDescriptor
extends ParserDescriptor {
    private static final String ID = "findbugs";
    private static final String NAME = "FindBugs";
    public static final String PRIORITY_OPTION_KEY = "SPOT_BUGS_CONFIDENCE";
    private final Deferred<FindBugsMessages> messages = new Deferred<FindBugsMessages>(FindBugsMessages::new);

    FindBugsDescriptor() {
        super(ID, NAME);
    }

    FindBugsDescriptor(String id, String name) {
        super(id, name);
    }

    @Override
    public IssueParser create(ParserDescriptor.Option ... options) {
        for (ParserDescriptor.Option option : options) {
            if (!PRIORITY_OPTION_KEY.equals(option.getKey()) || !FindBugsParser.PriorityProperty.CONFIDENCE.name().equals(option.getValue())) continue;
            return new FindBugsParser(FindBugsParser.PriorityProperty.CONFIDENCE);
        }
        return new FindBugsParser(FindBugsParser.PriorityProperty.RANK);
    }

    @Override
    public String getPattern() {
        return "**/findbugsXml.xml";
    }

    @Override
    public String getDescription(Issue issue) {
        return this.messages.get().getMessage(issue.getType());
    }

    @Override
    public Report.IssueType getType() {
        return Report.IssueType.BUG;
    }
}

