/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.LookaheadParser;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.LookaheadStream;
import java.util.Optional;
import java.util.regex.Matcher;

public class TaskingVxCompilerParser
extends LookaheadParser {
    private static final long serialVersionUID = -5225265084645449716L;
    private static final String TASKING_VX_COMPILER_WARNING_PATTERN = "^[a-z0-9]+? (I|W|E|F)(\\d+): (?:\\[\"(.*?)\" (\\d+)\\/(\\d+)\\] )?(.*)$";

    public TaskingVxCompilerParser() {
        super(TASKING_VX_COMPILER_WARNING_PATTERN);
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, LookaheadStream lookahead, IssueBuilder builder) {
        String type;
        switch (type = matcher.group(1)) {
            case "F": {
                builder.setSeverity(Severity.ERROR);
                break;
            }
            case "E": {
                builder.setSeverity(Severity.WARNING_HIGH);
                break;
            }
            case "I": {
                builder.setSeverity(Severity.WARNING_LOW);
                break;
            }
            default: {
                builder.setSeverity(Severity.WARNING_NORMAL);
            }
        }
        return builder.setFileName(matcher.group(3)).setLineStart(matcher.group(4)).setMessage(matcher.group(6)).buildOptional();
    }
}

