/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.helpers.DefaultHandler;

public class QtTranslationParser
extends IssueParser {
    private static final long serialVersionUID = 1L;
    static final String TRANSLATION_TYPE_OBSOLETE = "obsolete";
    static final String TRANSLATION_TYPE_UNFINISHED = "unfinished";
    static final String TRANSLATION_TYPE_UNFINISHED_NOT_EMPTY = "unfinished_not_empty";
    static final String TRANSLATION_TYPE_VANISHED = "vanished";
    static final String TRANSLATION_TYPE_OBSOLETE_MESSAGE = "This translation can be removed because the source no longer exists.";
    static final String TRANSLATION_TYPE_UNFINISHED_MESSAGE = "This source string is missing a translation.";
    static final String TRANSLATION_TYPE_UNFINISHED_NOT_EMPTY_MESSAGE = "This source string contains a translation, but is still marked as unfinished.";
    static final String TRANSLATION_TYPE_VANISHED_MESSAGE = "The source string cannot be found within the sources. Remove this translation if it is no longer used, or improve your call to \"tr()\" so that \"lupdate\" can find it.";

    @Override
    public Report parseReport(ReaderFactory readerFactory) throws ParsingException {
        Report report = new Report();
        readerFactory.parse(new QtTranslationSaxParser(report, readerFactory.getFileName()));
        return report;
    }

    static class QtTranslationSaxParser
    extends DefaultHandler {
        private static final String CONTEXT = "context";
        private static final String CONTEXT_NAME = "name";
        private static final String MESSAGE = "message";
        private static final String MESSAGE_NUMERUS_ATTRIBUTE = "numerus";
        private static final String MESSAGE_NUMERUS_ENABLED_VALUE = "yes";
        private static final String NUMERUSFORM = "numerusform";
        private static final String ROOT = "TS";
        private static final String SOURCE = "source";
        private static final String TRANSLATION = "translation";
        private static final String TRANSLATION_ATTR_TYPE = "type";
        @SuppressFBWarnings(value={"NP_NONNULL_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"})
        private Locator documentLocator;
        private final Report report;
        private final IssueBuilder builder = new IssueBuilder();
        private final Deque<String> elementTypeStack = new ArrayDeque<String>();
        private final Map<String, String> expectedElementTypeParents = new HashMap<String, String>();
        private String contextName = "";
        private String sourceValue = "";
        private String translationType = "";
        private boolean hasTranslatedString;
        private boolean translationTagFound;
        private boolean messageIsNumerus;
        private int lastColumnNumber;

        QtTranslationSaxParser(Report report, String fileName) {
            this.expectedElementTypeParents.put(ROOT, null);
            this.expectedElementTypeParents.put(CONTEXT, ROOT);
            this.expectedElementTypeParents.put(CONTEXT_NAME, CONTEXT);
            this.expectedElementTypeParents.put(MESSAGE, CONTEXT);
            this.expectedElementTypeParents.put(NUMERUSFORM, TRANSLATION);
            this.expectedElementTypeParents.put(TRANSLATION, MESSAGE);
            this.expectedElementTypeParents.put(SOURCE, MESSAGE);
            this.report = report;
            this.builder.setFileName(fileName);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.documentLocator = locator;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String key, Attributes atts) {
            this.verifyElementTypeRelation(key);
            this.elementTypeStack.push(key);
            switch (key) {
                case "name": {
                    this.throwParsingExceptionBecauseOfDuplicatedOccurrence(!this.contextName.isEmpty(), key);
                    break;
                }
                case "source": {
                    this.throwParsingExceptionBecauseOfDuplicatedOccurrence(!this.sourceValue.isEmpty(), key);
                    break;
                }
                case "translation": {
                    this.throwParsingExceptionBecauseOfDuplicatedOccurrence(this.translationTagFound, key);
                    this.translationTagFound = true;
                    this.translationType = atts.getValue(TRANSLATION_ATTR_TYPE);
                    if (this.translationType == null) break;
                    this.applyTranslationType();
                    break;
                }
                case "message": {
                    this.builder.setLineStart(this.documentLocator.getLineNumber());
                    this.builder.setColumnStart(this.lastColumnNumber);
                    this.messageIsNumerus = MESSAGE_NUMERUS_ENABLED_VALUE.equals(atts.getValue(MESSAGE_NUMERUS_ATTRIBUTE));
                    break;
                }
                case "numerusform": {
                    if (this.messageIsNumerus) break;
                    throw new ParsingException("Element type \"%s\" is allowed only if the attribute \"%s\" within the parent element \"%s\" is set to \"%s\" (line %d).", NUMERUSFORM, MESSAGE_NUMERUS_ATTRIBUTE, MESSAGE, MESSAGE_NUMERUS_ENABLED_VALUE, this.documentLocator.getLineNumber());
                }
            }
            this.lastColumnNumber = this.documentLocator.getColumnNumber();
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            this.elementTypeStack.pop();
            this.lastColumnNumber = this.documentLocator.getColumnNumber();
            if (CONTEXT.equals(qName)) {
                this.contextName = "";
                return;
            }
            if (!MESSAGE.equals(qName)) {
                return;
            }
            this.throwParsingExceptionBecauseOfMissingElementType(this.contextName.isEmpty(), CONTEXT_NAME);
            this.throwParsingExceptionBecauseOfMissingElementType(this.sourceValue.isEmpty(), SOURCE);
            this.throwParsingExceptionBecauseOfMissingElementType(!this.translationTagFound, TRANSLATION);
            if (this.translationType != null) {
                if (QtTranslationParser.TRANSLATION_TYPE_UNFINISHED.equals(this.translationType) && this.hasTranslatedString) {
                    this.builder.setSeverity(Severity.WARNING_LOW);
                    this.builder.setMessage(QtTranslationParser.TRANSLATION_TYPE_UNFINISHED_NOT_EMPTY_MESSAGE);
                    this.builder.setCategory(QtTranslationParser.TRANSLATION_TYPE_UNFINISHED_NOT_EMPTY);
                }
                this.builder.setLineEnd(this.documentLocator.getLineNumber());
                this.builder.setColumnEnd(this.documentLocator.getColumnNumber());
                this.report.add(this.builder.build());
            }
            this.hasTranslatedString = false;
            this.translationTagFound = false;
            this.sourceValue = "";
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.lastColumnNumber = this.documentLocator.getColumnNumber();
            if (CONTEXT_NAME.equals(this.elementTypeStack.getFirst())) {
                this.contextName = new String(ch, start, length);
            }
            if (SOURCE.equals(this.elementTypeStack.getFirst())) {
                this.sourceValue = new String(ch, start, length);
            }
            if (TRANSLATION.equals(this.elementTypeStack.getFirst())) {
                this.hasTranslatedString |= !this.messageIsNumerus;
            }
            if (NUMERUSFORM.equals(this.elementTypeStack.getFirst())) {
                this.hasTranslatedString = true;
            }
        }

        private void verifyElementTypeRelation(String element) {
            String parent = this.expectedElementTypeParents.getOrDefault(element, "");
            if (parent == null) {
                if (!this.elementTypeStack.isEmpty()) {
                    throw new ParsingException("Element type \"%s\" does not expect to be a root element (line %d).", element, this.documentLocator.getLineNumber());
                }
                return;
            }
            if (!parent.isEmpty() && !this.elementTypeStack.getFirst().equals(parent)) {
                throw new ParsingException("Element type \"%s\" expects to be a child element of element type \"%s\" (line %d).", element, parent, this.documentLocator.getLineNumber());
            }
        }

        private void throwParsingExceptionBecauseOfDuplicatedOccurrence(boolean shouldThrow, String element) {
            if (shouldThrow) {
                throw new ParsingException("Element type \"%s\" can be used only once within element type \"%s\" (line %d).", element, this.expectedElementTypeParents.get(element), this.documentLocator.getLineNumber());
            }
        }

        private void throwParsingExceptionBecauseOfMissingElementType(boolean shouldThrow, String element) {
            if (shouldThrow) {
                throw new ParsingException("Missing or empty element type \"%s\" within element type \"%s\" (line %d).", element, this.expectedElementTypeParents.get(element), this.documentLocator.getLineNumber());
            }
        }

        private void applyTranslationType() {
            switch (this.translationType) {
                case "obsolete": {
                    this.builder.setSeverity(Severity.WARNING_NORMAL);
                    this.builder.setMessage(QtTranslationParser.TRANSLATION_TYPE_OBSOLETE_MESSAGE);
                    break;
                }
                case "unfinished": {
                    this.builder.setSeverity(Severity.WARNING_LOW);
                    this.builder.setMessage(QtTranslationParser.TRANSLATION_TYPE_UNFINISHED_MESSAGE);
                    break;
                }
                case "vanished": {
                    this.builder.setSeverity(Severity.WARNING_NORMAL);
                    this.builder.setMessage(QtTranslationParser.TRANSLATION_TYPE_VANISHED_MESSAGE);
                    break;
                }
                default: {
                    throw new ParsingException("Unknown translation state \"%s\" (line %d).", this.translationType, this.documentLocator.getLineNumber());
                }
            }
            this.builder.setCategory(this.translationType);
        }

        @Override
        public void endDocument() {
            this.builder.close();
        }
    }
}

