/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.LookaheadParser;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.LookaheadStream;
import java.util.Optional;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;

public class PyLintParser
extends LookaheadParser {
    private static final long serialVersionUID = 4464053085862883240L;
    private static final String PYLINT_PATTERN = "(?<path>(?:[A-Z]:\\\\)?[^:]*)(?:\\:(?<module>.*))?:(?<line>\\d+): \\[(?<type>(?<category>[A-Z])\\d*)?(?:\\((?<symbol>.*)\\), )?.*?\\] (?<message>.*)";
    private static final String UNKNOWN_CAT = "pylint-unknown-category";
    private static final String UNKNOWN_TYPE = "pylint-unknown-type";

    public PyLintParser() {
        super(PYLINT_PATTERN);
    }

    @Override
    protected boolean isLineInteresting(String line) {
        return line.contains("[");
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, LookaheadStream lookahead, IssueBuilder builder) {
        String category = matcher.group("category");
        builder.setSeverity(this.mapPriority(category));
        builder.setCategory(this.mapCategory(category));
        builder.setType((String)StringUtils.firstNonBlank((CharSequence[])new String[]{matcher.group("symbol"), matcher.group("type"), UNKNOWN_TYPE}));
        String moduleName = matcher.group("module");
        if (moduleName == null) {
            builder.setPackageName("-").setModuleName("-");
        } else {
            if (moduleName.contains(".")) {
                builder.setPackageName(moduleName.substring(0, moduleName.lastIndexOf(46)));
            } else {
                builder.setPackageName("-");
            }
            builder.setModuleName(moduleName);
        }
        return builder.setFileName(matcher.group("path")).setLineStart(matcher.group("line")).setMessage(matcher.group("message")).buildOptional();
    }

    private String mapCategory(String category) {
        if (StringUtils.isEmpty((CharSequence)category)) {
            return UNKNOWN_CAT;
        }
        return switch (category) {
            case "I" -> "Informational";
            case "R" -> "Refactor";
            case "C" -> "Convention";
            case "W" -> "Warning";
            case "E" -> "Error";
            case "F" -> "Fatal";
            default -> UNKNOWN_CAT;
        };
    }

    private Severity mapPriority(String category) {
        if (StringUtils.isEmpty((CharSequence)category)) {
            return Severity.WARNING_NORMAL;
        }
        return switch (category) {
            case "I", "R", "C" -> Severity.WARNING_LOW;
            case "W" -> Severity.WARNING_NORMAL;
            case "E" -> Severity.WARNING_HIGH;
            case "F" -> Severity.ERROR;
            default -> Severity.WARNING_LOW;
        };
    }
}

