/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;

public class PyLintDescriptions {
    static final String NO_DESCRIPTION_FOUND = "no description found";
    private final Map<String, String> descriptionByName = new HashMap<String, String>();
    private final Map<String, String> descriptionById = new HashMap<String, String>();

    public PyLintDescriptions() {
        JSONParser parser = new JSONParser(8128);
        try (InputStream inputStream = PyLintDescriptions.class.getResourceAsStream("pylint-descriptions.json");){
            JSONArray elements = (JSONArray)parser.parse(inputStream);
            for (Object element : elements) {
                JSONObject object = (JSONObject)element;
                String description = object.getAsString("description");
                this.descriptionByName.put(object.getAsString("name"), description);
                this.descriptionById.put(object.getAsString("code"), description);
            }
        }
        catch (IOException | ParseException throwable) {
            // empty catch block
        }
    }

    public int size() {
        return this.descriptionById.size();
    }

    public String getDescription(String name) {
        return this.descriptionByName.getOrDefault(name, this.descriptionById.getOrDefault(name, NO_DESCRIPTION_FOUND));
    }
}

