/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.SecureDigester;
import edu.hm.hafner.analysis.Severity;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.Strings;
import org.xml.sax.SAXException;

public class PmdParser
extends IssueParser {
    private static final long serialVersionUID = 6507147028628714706L;
    private static final int PMD_PRIORITY_MAPPED_TO_HIGH_PRIORITY = 3;
    private static final int PMD_PRIORITY_MAPPED_TO_LOW_PRIORITY = 4;

    @Override
    public Report parseReport(ReaderFactory readerFactory) throws ParsingException {
        Report issues = this.parseIssues(readerFactory);
        this.parseErrors(readerFactory).stream().forEach(issues::add);
        return issues;
    }

    private Report parseIssues(ReaderFactory readerFactory) {
        Report report;
        block9: {
            SecureDigester digester = new SecureDigester(PmdParser.class);
            String rootXPath = "pmd";
            digester.addObjectCreate(rootXPath, Pmd.class);
            digester.addSetProperties(rootXPath);
            String fileXPath = "pmd/file";
            digester.addObjectCreate(fileXPath, File.class);
            digester.addSetProperties(fileXPath);
            digester.addSetNext(fileXPath, "addFile", File.class.getName());
            String bugXPath = "pmd/file/violation";
            digester.addObjectCreate(bugXPath, Violation.class);
            digester.addSetProperties(bugXPath);
            digester.addCallMethod(bugXPath, "setMessage", 0);
            digester.addSetNext(bugXPath, "addViolation", Violation.class.getName());
            Reader reader = readerFactory.create();
            try {
                Pmd pmd = (Pmd)digester.parse(reader);
                if (pmd == null) {
                    throw new ParsingException(readerFactory, "Input stream is not a PMD file.", new Object[0]);
                }
                report = this.convertIssues(pmd);
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | SAXException exception) {
                    throw new ParsingException(exception, readerFactory);
                }
            }
            reader.close();
        }
        return report;
    }

    private Report parseErrors(ReaderFactory readerFactory) {
        Report report;
        block9: {
            SecureDigester digester = new SecureDigester(PmdParser.class);
            String rootXPath = "pmd";
            digester.addObjectCreate(rootXPath, Pmd.class);
            digester.addSetProperties(rootXPath);
            String errorXPath = "pmd/error";
            digester.addObjectCreate(errorXPath, PmdError.class);
            digester.addSetProperties(errorXPath);
            digester.addSetNext(errorXPath, "addError", PmdError.class.getName());
            digester.addCallMethod(errorXPath, "setDescription", 0);
            Reader reader = readerFactory.create();
            try {
                Pmd pmd = (Pmd)digester.parse(reader);
                if (pmd == null) {
                    throw new ParsingException(readerFactory, "Input stream is not a PMD file.", new Object[0]);
                }
                report = this.convertErrors(pmd);
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | SAXException exception) {
                    throw new ParsingException(exception, readerFactory);
                }
            }
            reader.close();
        }
        return report;
    }

    private Report convertIssues(Pmd pmdIssues) {
        try (IssueBuilder issueBuilder = new IssueBuilder();){
            Report report = new Report();
            for (File file : pmdIssues.getFiles()) {
                for (Violation warning : file.getViolations()) {
                    issueBuilder.setSeverity(this.mapPriority(warning)).setMessage(this.createMessage(warning)).setCategory(warning.getRuleset()).setType(warning.getRule()).setLineStart(warning.getBeginline()).setLineEnd(warning.getEndline()).setPackageName(warning.getPackage()).setFileName(file.getName()).setColumnStart(warning.getBegincolumn()).setColumnEnd(warning.getEndcolumn());
                    report.add(issueBuilder.buildAndClean());
                }
            }
            Report report2 = report;
            return report2;
        }
    }

    private Report convertErrors(Pmd pmdIssues) {
        try (IssueBuilder issueBuilder = new IssueBuilder();){
            Report report = new Report();
            for (PmdError error : pmdIssues.getErrors()) {
                issueBuilder.setSeverity(Severity.ERROR).setMessage(error.getMsg()).setDescription(error.getDescription()).setFileName(error.getFilename());
                report.add(issueBuilder.buildAndClean());
            }
            Report report2 = report;
            return report2;
        }
    }

    private Severity mapPriority(Violation warning) {
        if (warning.getPriority() < 3) {
            return Severity.WARNING_HIGH;
        }
        if (warning.getPriority() > 4) {
            return Severity.WARNING_LOW;
        }
        return Severity.WARNING_NORMAL;
    }

    private String createMessage(Violation warning) {
        String original = warning.getMessage();
        if (original == null) {
            return "";
        }
        if (Strings.CS.endsWith((CharSequence)original, (CharSequence)".")) {
            return original;
        }
        return original + ".";
    }

    public static class Pmd {
        private final List<File> files = new ArrayList<File>();
        private final List<PmdError> errors = new ArrayList<PmdError>();

        public void addFile(File file) {
            this.files.add(file);
        }

        public void addError(PmdError error) {
            this.errors.add(error);
        }

        public Collection<File> getFiles() {
            return Collections.unmodifiableCollection(this.files);
        }

        public Collection<PmdError> getErrors() {
            return Collections.unmodifiableCollection(this.errors);
        }
    }

    public static class File {
        @CheckForNull
        private String name;
        private final List<Violation> violations = new ArrayList<Violation>();

        public void addViolation(Violation violation) {
            this.violations.add(violation);
        }

        public Collection<Violation> getViolations() {
            return Collections.unmodifiableCollection(this.violations);
        }

        @CheckForNull
        public String getName() {
            return this.name;
        }

        public void setName(@CheckForNull String name) {
            this.name = name;
        }
    }

    public static class Violation {
        @CheckForNull
        private String rule;
        @CheckForNull
        private String ruleset;
        @CheckForNull
        private String externalInfoUrl;
        @CheckForNull
        private String javaPackage;
        private int priority;
        @CheckForNull
        private String message;
        private int beginline;
        private int endline;
        private int begincolumn;
        private int endcolumn;

        @CheckForNull
        public String getRule() {
            return this.rule;
        }

        public void setRule(String rule) {
            this.rule = rule;
        }

        @CheckForNull
        public String getRuleset() {
            return this.ruleset;
        }

        public void setRuleset(String ruleset) {
            this.ruleset = ruleset;
        }

        @CheckForNull
        public String getExternalInfoUrl() {
            return this.externalInfoUrl;
        }

        public void setExternalInfoUrl(String externalInfoUrl) {
            this.externalInfoUrl = externalInfoUrl;
        }

        @CheckForNull
        public String getPackage() {
            return this.javaPackage;
        }

        public void setPackage(String packageName) {
            this.javaPackage = packageName;
        }

        public int getPriority() {
            return this.priority;
        }

        public void setPriority(int priority) {
            this.priority = priority;
        }

        @CheckForNull
        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public int getBeginline() {
            return this.beginline;
        }

        public void setBeginline(int beginline) {
            this.beginline = beginline;
        }

        public int getEndline() {
            return this.endline;
        }

        public void setEndline(int endline) {
            this.endline = endline;
        }

        public int getEndcolumn() {
            return this.endcolumn;
        }

        public void setEndcolumn(int endcolumn) {
            this.endcolumn = endcolumn;
        }

        public int getBegincolumn() {
            return this.begincolumn;
        }

        public void setBegincolumn(int begincolumn) {
            this.begincolumn = begincolumn;
        }
    }

    public static class PmdError {
        @CheckForNull
        private String filename;
        @CheckForNull
        private String msg;
        @CheckForNull
        private String description;

        @CheckForNull
        public String getFilename() {
            return this.filename;
        }

        public void setFilename(@CheckForNull String filename) {
            this.filename = filename;
        }

        @CheckForNull
        public String getMsg() {
            return this.msg;
        }

        public void setMsg(@CheckForNull String msg) {
            this.msg = msg;
        }

        @CheckForNull
        public String getDescription() {
            return this.description;
        }

        public void setDescription(@CheckForNull String description) {
            this.description = description;
        }
    }
}

