/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.LookaheadParser;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.LookaheadStream;
import java.util.Optional;
import java.util.regex.Matcher;

public class MetrowerksCwLinkerParser
extends LookaheadParser {
    private static final long serialVersionUID = 5993528761040876178L;
    private static final String CW_LINKER_WARNING_PATTERN = "^(INFORMATION|WARNING|ERROR) (.+)$";

    public MetrowerksCwLinkerParser() {
        super(CW_LINKER_WARNING_PATTERN);
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, LookaheadStream lookahead, IssueBuilder builder) {
        String category;
        Severity priority;
        String message = matcher.group(2);
        String messageCategory = matcher.group(1);
        if (MetrowerksCwLinkerParser.equalsIgnoreCase(messageCategory, "error")) {
            priority = Severity.WARNING_HIGH;
            category = "ERROR";
        } else if (MetrowerksCwLinkerParser.equalsIgnoreCase(messageCategory, "information")) {
            priority = Severity.WARNING_LOW;
            category = "Info";
        } else {
            priority = Severity.WARNING_NORMAL;
            category = "Warning";
        }
        return builder.setFileName("See Warning message").setLineStart(0).setCategory(category).setMessage(message).setSeverity(priority).buildOptional();
    }
}

