/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.LookaheadParser;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.LookaheadStream;
import java.util.Optional;
import java.util.regex.Matcher;

public class LlvmLinkerParser
extends LookaheadParser {
    private static final long serialVersionUID = 1L;
    private static final String LLD_LINKER_PATTERN = "^(?<linker>.*[/\\\\]?ld\\.lld(?:-\\d+)?(?:\\.exe)?):\\s*(?<severity>error|warning|note):\\s*(?<message>.*)$";

    public LlvmLinkerParser() {
        super(LLD_LINKER_PATTERN);
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, LookaheadStream lookahead, IssueBuilder builder) {
        String linkerPath = matcher.group("linker");
        String severity = matcher.group("severity");
        String message = matcher.group("message");
        String fileName = "/" + linkerPath.replaceFirst("^.*[/\\\\]", "");
        return builder.setFileName(fileName).setLineStart(0).setColumnStart(0).setCategory("Linker").setMessage(message.trim()).setSeverity(this.mapPriority(severity)).buildOptional();
    }

    private Severity mapPriority(String severity) {
        return switch (severity) {
            case "error" -> Severity.WARNING_HIGH;
            case "warning" -> Severity.WARNING_NORMAL;
            case "note" -> Severity.WARNING_LOW;
            default -> Severity.WARNING_NORMAL;
        };
    }
}

