/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.LookaheadParser;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.LookaheadStream;
import java.util.Optional;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;

public class InvalidsParser
extends LookaheadParser {
    private static final long serialVersionUID = 440910718005095427L;
    static final String WARNING_PREFIX = "Oracle ";
    private static final String INVALIDS_PATTERN = "^\\s*(\\w+),([a-zA-Z#_0-9/]*),([A-Z_ ]*),(.*),(\\d+),\\d+,([^:]*):\\s*(.*)$";

    public InvalidsParser() {
        super(INVALIDS_PATTERN);
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, LookaheadStream lookahead, IssueBuilder builder) {
        String type = WARNING_PREFIX + StringUtils.capitalize((String)StringUtils.lowerCase((String)matcher.group(4)));
        String category = matcher.group(6);
        Severity priority = Strings.CS.contains((CharSequence)category, (CharSequence)"PLW-07") ? Severity.WARNING_LOW : (Strings.CS.contains((CharSequence)category, (CharSequence)"ORA") ? Severity.WARNING_HIGH : Severity.WARNING_NORMAL);
        return builder.setFileName(matcher.group(2) + "." + matcher.group(3)).setLineStart(matcher.group(5)).setType(type).setCategory(category).setPackageName(matcher.group(1)).setMessage(matcher.group(7)).setSeverity(priority).buildOptional();
    }
}

