/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.util.IntegerParser;
import edu.hm.hafner.analysis.util.XmlElementUtil;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GendarmeParser
extends IssueParser {
    private static final long serialVersionUID = 1677715364464119907L;
    private static final Pattern FILE_PATTERN = Pattern.compile("^(.*)\\(.(\\d+)\\).*$");
    private static final String TYPE = "Type";
    private static final String METHOD = "Method";
    private static final String ASSEMBLY = "Assembly";

    @Override
    public Report parseReport(ReaderFactory factory) throws ParsingException {
        Document document = factory.readDocument();
        NodeList mainNode = document.getElementsByTagName("gendarme-output");
        Element rootElement = (Element)mainNode.item(0);
        Element resultsElement = (Element)rootElement.getElementsByTagName("results").item(0);
        Element rulesElement = (Element)rootElement.getElementsByTagName("rules").item(0);
        Map<String, GendarmeRule> rules = this.parseRules(XmlElementUtil.getChildElementsByName(rulesElement, "rule"));
        return this.parseViolations(XmlElementUtil.getChildElementsByName(resultsElement, "rule"), rules);
    }

    private Report parseViolations(List<Element> ruleElements, Map<String, GendarmeRule> rules) {
        try (IssueBuilder issueBuilder = new IssueBuilder();){
            Report warnings = new Report();
            for (Element ruleElement : ruleElements) {
                String ruleName = ruleElement.getAttribute("Name");
                String problem = ruleElement.getElementsByTagName("problem").item(0).getTextContent();
                List<Element> targetElements = XmlElementUtil.getChildElementsByName(ruleElement, "target");
                GendarmeRule rule = rules.get(ruleName);
                if (rule == null) continue;
                for (Element targetElement : targetElements) {
                    Element defectElement = (Element)targetElement.getElementsByTagName("defect").item(0);
                    String source = defectElement.getAttribute("Source");
                    String fileName = this.extractFileNameMatch(rule, source, 1);
                    Severity priority = this.extractPriority(defectElement);
                    int line = IntegerParser.parseInt(this.extractFileNameMatch(rule, source, 2));
                    issueBuilder.setFileName(fileName).setLineStart(line).setCategory(rule.getName()).setMessage(problem).setSeverity(priority);
                    warnings.add(issueBuilder.buildAndClean());
                }
            }
            Report report = warnings;
            return report;
        }
    }

    private Severity extractPriority(Element defectElement) {
        return switch (defectElement.getAttribute("Severity")) {
            case "Low" -> Severity.WARNING_LOW;
            case "High" -> Severity.WARNING_HIGH;
            default -> Severity.WARNING_NORMAL;
        };
    }

    private String extractFileNameMatch(GendarmeRule rule, String source, int group) {
        Matcher matcher;
        String fileName = "";
        if (rule.getType() == GendarmeRuleType.METHOD && (matcher = FILE_PATTERN.matcher(source)).matches()) {
            fileName = matcher.group(group);
        }
        return fileName;
    }

    private Map<String, GendarmeRule> parseRules(List<Element> ruleElements) {
        HashMap<String, GendarmeRule> rules = new HashMap<String, GendarmeRule>();
        for (Element ruleElement : ruleElements) {
            String typeString;
            GendarmeRule rule = new GendarmeRule();
            rule.setName(ruleElement.getAttribute("Name"));
            rule.setTypeName(ruleElement.getTextContent());
            switch (typeString = ruleElement.getAttribute(TYPE)) {
                case "Type": {
                    rule.setType(GendarmeRuleType.TYPE);
                    break;
                }
                case "Method": {
                    rule.setType(GendarmeRuleType.METHOD);
                    break;
                }
                case "Assembly": {
                    rule.setType(GendarmeRuleType.ASSEMBLY);
                    break;
                }
            }
            try {
                rule.setUrl(new URL(ruleElement.getAttribute("Uri")));
            }
            catch (MalformedURLException ignored) {
                rule.setUrl(null);
            }
            rules.put(rule.getName(), rule);
        }
        return rules;
    }

    static class GendarmeRule {
        @CheckForNull
        private String name;
        @CheckForNull
        private String typeName;
        @CheckForNull
        private GendarmeRuleType type;
        @CheckForNull
        private URL url;

        GendarmeRule() {
        }

        @CheckForNull
        public String getTypeName() {
            return this.typeName;
        }

        public void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @CheckForNull
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @CheckForNull
        public GendarmeRuleType getType() {
            return this.type;
        }

        public void setType(GendarmeRuleType type) {
            this.type = type;
        }

        @CheckForNull
        public URL getUrl() {
            return this.url;
        }

        public void setUrl(@CheckForNull URL url) {
            this.url = url;
        }
    }

    static enum GendarmeRuleType {
        METHOD,
        TYPE,
        ASSEMBLY;

    }
}

