/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.parser.JsonParser;
import java.util.Optional;
import org.json.JSONObject;

public class DScannerParser
extends JsonParser {
    private static final long serialVersionUID = -3396574381502866972L;
    private static final String KEY = "key";
    private static final String LINE = "line";
    private static final String COLUMN = "column";

    @Override
    Optional<Issue> convertToIssue(JSONObject jsonIssue, IssueBuilder builder) {
        if (jsonIssue.has(KEY)) {
            String key = jsonIssue.getString(KEY);
            builder.setCategory(key);
            builder.setSeverity(this.getSeverityByKey(key));
        }
        if (jsonIssue.has("fileName")) {
            builder.setFileName(jsonIssue.getString("fileName"));
        }
        if (jsonIssue.has(LINE)) {
            builder.setLineStart(jsonIssue.getInt(LINE));
        }
        if (jsonIssue.has(COLUMN)) {
            builder.setColumnStart(jsonIssue.getInt(COLUMN));
        }
        if (jsonIssue.has("message")) {
            builder.setMessage(jsonIssue.getString("message"));
        }
        return builder.buildOptional();
    }

    private Severity getSeverityByKey(String key) {
        String[] parts = key.split("\\.", -1);
        return switch (parts[1]) {
            case "suspicious", "deprecated" -> Severity.WARNING_NORMAL;
            case "bugs" -> Severity.WARNING_HIGH;
            default -> Severity.WARNING_LOW;
        };
    }
}

