/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.DuplicationGroup;
import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.parser.AbstractDryParser;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.digester3.Digester;

public class CpdParser
extends AbstractDryParser<Duplication> {
    private static final long serialVersionUID = 6507147028628714706L;

    public CpdParser(int highThreshold, int normalThreshold) {
        super(highThreshold, normalThreshold);
    }

    public CpdParser() {
        super(50, 25);
    }

    @Override
    protected void configureParser(Digester digester) {
        String duplicationXPath = "*/pmd-cpd/duplication";
        digester.addObjectCreate(duplicationXPath, Duplication.class);
        digester.addSetProperties(duplicationXPath);
        digester.addCallMethod(duplicationXPath + "/codefragment", "setCodeFragment", 0);
        digester.addSetNext(duplicationXPath, "add");
        String fileXPath = duplicationXPath + "/file";
        digester.addObjectCreate(fileXPath, SourceFile.class);
        digester.addSetProperties(fileXPath);
        digester.addSetNext(fileXPath, "addFile", SourceFile.class.getName());
    }

    @Override
    protected Report convertDuplicationsToIssues(List<Duplication> duplications, IssueBuilder issueBuilder) {
        Report report = new Report();
        for (Duplication duplication : duplications) {
            DuplicationGroup group = new DuplicationGroup(duplication.getCodeFragment());
            for (SourceFile file : duplication.getFiles()) {
                issueBuilder.setSeverity(this.getPriority(duplication.getLines())).setLineStart(file.getLine()).setLineEnd(file.getLine() + duplication.getLines() - 1).setFileName(file.getPath()).setType("CPD").setAdditionalProperties(group);
                Issue issue = issueBuilder.build();
                group.add(issue);
                report.add(issue);
            }
        }
        return report;
    }

    public static class Duplication {
        private int lines;
        private int tokens;
        @CheckForNull
        private String codeFragment;
        private final List<SourceFile> files = new ArrayList<SourceFile>();

        public void addFile(SourceFile file) {
            this.files.add(file);
        }

        public Collection<SourceFile> getFiles() {
            return Collections.unmodifiableCollection(this.files);
        }

        public int getLines() {
            return this.lines;
        }

        public void setLines(int lines) {
            this.lines = lines;
        }

        public int getTokens() {
            return this.tokens;
        }

        public void setTokens(int tokens) {
            this.tokens = tokens;
        }

        @CheckForNull
        public String getCodeFragment() {
            return this.codeFragment;
        }

        public void setCodeFragment(@CheckForNull String codeFragment) {
            this.codeFragment = codeFragment;
        }
    }

    public static class SourceFile {
        private int line;
        @CheckForNull
        private String path;

        @CheckForNull
        public String getPath() {
            return this.path;
        }

        public void setPath(@CheckForNull String path) {
            this.path = path;
        }

        public int getLine() {
            return this.line;
        }

        public void setLine(int line) {
            this.line = line;
        }
    }
}

