/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.LookaheadParser;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.LookaheadStream;
import java.util.Optional;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;

public class ClangTidyParser
extends LookaheadParser {
    private static final long serialVersionUID = -3015592762345283182L;
    private static final String CLANG_TIDY_WARNING_PATTERN = "(?:clang-tidy\\S* (?:-\\S+ )*|)((.+):(\\d+):(\\d+): |)(warning|error): (.*?) \\[([^\\s]*?)\\]$";

    public ClangTidyParser() {
        super(CLANG_TIDY_WARNING_PATTERN);
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, LookaheadStream lookahead, IssueBuilder builder) {
        Severity priority = matcher.group(5).contains("error") ? Severity.WARNING_HIGH : Severity.WARNING_NORMAL;
        String category = matcher.group(7);
        if (category.startsWith("-W")) {
            return Optional.empty();
        }
        return builder.setFileName(matcher.group(2)).setSeverity(priority).setLineStart(matcher.group(3)).setColumnStart(matcher.group(4)).setType(StringUtils.capitalize((String)matcher.group(5))).setCategory(category).setMessage(matcher.group(6)).buildOptional();
    }
}

