/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.SecureDigester;
import edu.hm.hafner.analysis.parser.CheckStyleParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.digester3.Digester;
import org.apache.commons.digester3.Rule;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.xml.sax.SAXException;

public class CheckStyleRules {
    private final Map<String, CheckStyleParser.Rule> rulesByName = new HashMap<String, CheckStyleParser.Rule>();

    public CheckStyleRules() {
        String[] ruleFiles;
        for (String ruleFile : ruleFiles = new String[]{"annotation", "blocks", "coding", "design", "filters", "header", "imports", "javadoc", "metrics", "misc", "modifier", "naming", "regexp", "reporting", "sizes", "whitespace"}) {
            try (InputStream inputStream = CheckStyleRules.class.getResourceAsStream("checkstyle/config_" + ruleFile + ".xml");){
                Digester digester = this.createDigester();
                ArrayList rules = new ArrayList();
                digester.push(rules);
                digester.parse(inputStream);
                for (CheckStyleParser.Rule rule : rules) {
                    if (!StringUtils.isNotBlank((CharSequence)rule.getDescription())) continue;
                    this.rulesByName.put(rule.getName(), rule);
                }
            }
            catch (IOException | ParserConfigurationException | SAXException exception) {
                this.log(exception);
            }
        }
    }

    private void log(Throwable exception) {
        Logger.getLogger(CheckStyleRules.class.getName()).log(Level.SEVERE, "Can't initialize CheckStyle rules.", exception);
    }

    private Digester createDigester() throws ParserConfigurationException {
        SecureDigester digester = new SecureDigester(CheckStyleRules.class);
        String section = "*/section";
        digester.addObjectCreate(section, CheckStyleParser.Rule.class);
        digester.addSetProperties(section);
        digester.addSetNext(section, "add");
        String subSection = "*/section/subsection";
        digester.addObjectCreate(subSection, CheckStyleParser.Topic.class);
        digester.addSetProperties(subSection);
        digester.addSetNext(subSection, "setDescription");
        digester.addRule(subSection, (Rule)new CheckStyleParser.TopicRule());
        return digester;
    }

    public Collection<CheckStyleParser.Rule> getRules() {
        return Collections.unmodifiableCollection(this.rulesByName.values());
    }

    public CheckStyleParser.Rule getRule(String name) {
        CheckStyleParser.Rule rule = this.rulesByName.get(name);
        if (rule == null) {
            rule = this.rulesByName.get(Strings.CS.removeEnd(name, (CharSequence)"Check"));
        }
        if (rule == null) {
            return new CheckStyleParser.Rule(name);
        }
        return rule;
    }

    public String getDescription(String name) {
        return this.getRule(name).getDescription();
    }
}

