/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.parser.JsonIssueParser;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BrakemanParser
extends JsonIssueParser {
    private static final long serialVersionUID = 1374428573878091300L;

    @Override
    protected void parseJsonObject(Report report, JSONObject jsonReport, IssueBuilder issueBuilder) {
        JSONArray warnings = jsonReport.getJSONArray("warnings");
        for (Object warning : warnings) {
            report.add(this.convertToIssue((JSONObject)warning, issueBuilder));
        }
    }

    private Issue convertToIssue(JSONObject warning, IssueBuilder issueBuilder) throws JSONException {
        String code;
        String fileName = warning.getString("file");
        String category = warning.getString("warning_type");
        Severity severity = this.getSeverity(warning.getString("confidence"));
        String fingerprint = warning.getString("fingerprint");
        String warningType = warning.getString("check_name");
        StringBuilder message = new StringBuilder();
        message.append(warning.getString("message"));
        if (warning.has("code") && !(code = warning.optString("code", "")).isEmpty()) {
            message.append(": ").append(warning.getString("code"));
        }
        int line = warning.optInt("line", 1);
        return issueBuilder.setMessage(message.toString()).setCategory(category).setType(warningType).setSeverity(severity).setFileName(fileName).setLineStart(line).setFingerprint(fingerprint).buildAndClean();
    }

    private Severity getSeverity(String confidence) {
        if (BrakemanParser.equalsIgnoreCase(confidence, "Medium")) {
            return Severity.WARNING_NORMAL;
        }
        if (BrakemanParser.equalsIgnoreCase(confidence, "High")) {
            return Severity.WARNING_HIGH;
        }
        if (BrakemanParser.equalsIgnoreCase(confidence, "Weak")) {
            return Severity.WARNING_LOW;
        }
        return Severity.WARNING_HIGH;
    }
}

