/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import edu.hm.hafner.analysis.ParsingCanceledException;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.util.SecureXmlParserFactory;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.io.Serializable;
import java.util.Locale;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;

public abstract class IssueParser
implements Serializable {
    private static final long serialVersionUID = 5L;
    protected static final String ADDITIONAL_PROPERTIES = "additionalProperties";
    protected static final String CATEGORY = "category";
    protected static final String COLUMN_END = "columnEnd";
    protected static final String COLUMN_START = "columnStart";
    protected static final String DESCRIPTION = "description";
    protected static final String FILE_NAME = "fileName";
    protected static final String FINGERPRINT = "fingerprint";
    protected static final String ID = "id";
    protected static final String LINE_END = "lineEnd";
    protected static final String LINE_RANGES = "lineRanges";
    protected static final String LINE_RANGE_END = "end";
    protected static final String LINE_RANGE_START = "start";
    protected static final String LINE_START = "lineStart";
    protected static final String MESSAGE = "message";
    protected static final String MODULE_NAME = "moduleName";
    protected static final String PACKAGE_NAME = "packageName";
    protected static final String SEVERITY = "severity";
    protected static final String TYPE = "type";
    private String id = "-";
    private String name = "-";
    private Report.IssueType type = Report.IssueType.WARNING;

    public Report parse(ReaderFactory readerFactory) throws ParsingException, ParsingCanceledException {
        Report report = this.parseReport(readerFactory);
        report.setOrigin(this.id, this.name, this.type, readerFactory.getFileName());
        return report;
    }

    protected abstract Report parseReport(ReaderFactory var1) throws ParsingException, ParsingCanceledException;

    public final void setId(String id) {
        this.id = id;
    }

    protected String getId() {
        return this.id;
    }

    public final void setName(String name) {
        this.name = name;
    }

    protected String getName() {
        return this.name;
    }

    public final void setType(Report.IssueType type) {
        this.type = type;
    }

    protected Report.IssueType getType() {
        return this.type;
    }

    public boolean accepts(ReaderFactory readerFactory) {
        return true;
    }

    protected boolean isXmlFile(ReaderFactory readerFactory) {
        boolean bl;
        block8: {
            Stream<String> lines = readerFactory.readStream();
            try {
                bl = lines.limit(10L).anyMatch(line -> line.contains("<?xml"));
                if (lines == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ParsingException | SecureXmlParserFactory.ParsingException ignored) {
                    return false;
                }
            }
            lines.close();
        }
        return bl;
    }

    public static boolean equalsIgnoreCase(@CheckForNull String a, @CheckForNull String b) {
        return Strings.CI.equals(IssueParser.normalize(a), IssueParser.normalize(b));
    }

    private static String normalize(@CheckForNull String input) {
        return StringUtils.defaultString((String)input).toUpperCase(Locale.ENGLISH);
    }
}

