/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import com.google.errorprone.annotations.MustBeClosed;
import edu.hm.hafner.util.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.Locale;
import java.util.stream.Stream;

public class FullTextFingerprint {
    private static final int DEFAULT_LINES_LOOK_AHEAD = 3;
    private static final int LINE_RANGE_BUFFER_SIZE = 1000;
    private static final char[] HEX_CHARACTERS = "0123456789ABCDEF".toCharArray();
    private final MessageDigest digest;
    private final FileSystem fileSystem;
    private final int linesLookAhead;

    public FullTextFingerprint() {
        this(3);
    }

    public FullTextFingerprint(int linesLookAhead) {
        this(linesLookAhead, new FileSystem());
    }

    @VisibleForTesting
    @SuppressFBWarnings(value={"WEAK_MESSAGE_DIGEST_MD5"}, justification="The fingerprint is just used to track new warnings")
    FullTextFingerprint(int linesLookAhead, FileSystem fileSystem) {
        this.fileSystem = fileSystem;
        this.linesLookAhead = linesLookAhead;
        try {
            this.digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public String compute(String fileName, int line, Charset charset) throws IOException {
        try (Stream<String> lines = this.fileSystem.readLinesFromFile(fileName, charset);){
            String string = this.createFingerprint(line, lines, charset);
            return string;
        }
    }

    @VisibleForTesting
    String getFallbackFingerprint(String fileName) {
        return String.format(Locale.ENGLISH, "%x", fileName.hashCode());
    }

    @VisibleForTesting
    String createFingerprint(int line, Stream<String> lines, Charset charset) {
        String context = this.extractContext(line, lines.iterator());
        lines.close();
        this.digest.update(context.getBytes(charset));
        return this.asHex(this.digest.digest()).toUpperCase(Locale.ENGLISH);
    }

    private String asHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_CHARACTERS[v >>> 4];
            hexChars[j * 2 + 1] = HEX_CHARACTERS[v & 0xF];
        }
        return String.valueOf(hexChars);
    }

    @VisibleForTesting
    String extractContext(int affectedLine, Iterator<String> lines) {
        int line;
        if (affectedLine < 0) {
            return "";
        }
        int start = this.computeStartLine(affectedLine);
        StringBuilder context = new StringBuilder(1000);
        for (line = 1; lines.hasNext() && line < start - this.linesLookAhead; ++line) {
            lines.next();
        }
        while (lines.hasNext() && line <= start + this.linesLookAhead) {
            context.append(lines.next());
            ++line;
        }
        return context.toString();
    }

    private int computeStartLine(int affectedLine) {
        if (affectedLine == 0) {
            return this.linesLookAhead + 1;
        }
        return affectedLine;
    }

    @VisibleForTesting
    static class FileSystem {
        FileSystem() {
        }

        @MustBeClosed
        Stream<String> readLinesFromFile(String fileName, Charset charset) throws IOException, InvalidPathException {
            return Files.lines(Path.of(fileName, new String[0]), charset);
        }
    }
}

