/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.util.PathUtil;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class FileNameResolver {
    static final String NOTHING_TO_DO = "-> none of the issues requires resolving of paths";
    private static final PathUtil PATH_UTIL = new PathUtil();

    public void run(Report report, String sourceDirectoryPrefix, Predicate<String> skipFileNamePredicate) {
        this.run(report, sourceDirectoryPrefix, skipFileNamePredicate, "", "");
    }

    public void run(Report report, String sourceDirectoryPrefix, Predicate<String> skipFileNamePredicate, String sourcePathPrefix, String targetPathPrefix) {
        Set<Object> filesToProcess = report.getFiles().stream().filter(fileName -> this.isInterestingFileName((String)fileName, skipFileNamePredicate)).collect(Collectors.toSet());
        if (filesToProcess.isEmpty()) {
            report.logInfo(NOTHING_TO_DO, new Object[0]);
            return;
        }
        filesToProcess = this.applyPathMapping(report, sourcePathPrefix, targetPathPrefix, skipFileNamePredicate);
        Map<String, String> pathMapping = filesToProcess.parallelStream().collect(Collectors.toMap(fileName -> fileName, fileName -> this.makeRelative(sourceDirectoryPrefix, (String)fileName))).entrySet().parallelStream().filter(entry -> PATH_UTIL.exists((String)entry.getValue(), sourceDirectoryPrefix)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        try (IssueBuilder builder = new IssueBuilder();){
            report.stream().filter(issue -> pathMapping.containsKey(issue.getFileName())).forEach(issue -> issue.setFileName(sourceDirectoryPrefix, builder.internFileName((String)pathMapping.get(issue.getFileName()))));
        }
        report.logInfo("-> resolved paths in source directory (%d found, %d not found)", pathMapping.size(), filesToProcess.size() - pathMapping.size());
    }

    private Set<String> applyPathMapping(Report report, String sourcePathPrefix, String targetPathPrefix, Predicate<String> skipFileNamePredicate) {
        boolean shouldRemap;
        boolean bl = shouldRemap = !sourcePathPrefix.isEmpty() && !targetPathPrefix.isEmpty();
        if (shouldRemap) {
            report.logInfo("-> remapping paths from '%s' to '%s'", sourcePathPrefix, targetPathPrefix);
            try (IssueBuilder builder = new IssueBuilder();){
                report.stream().filter(issue -> issue.getFileName().startsWith(sourcePathPrefix)).forEach(issue -> {
                    String originalPath = issue.getFileName();
                    String remappedPath = targetPathPrefix + originalPath.substring(sourcePathPrefix.length());
                    issue.setFileName(issue.getPath(), builder.internFileName(remappedPath));
                });
            }
        }
        return report.getFiles().stream().filter(fileName -> this.isInterestingFileName((String)fileName, skipFileNamePredicate)).collect(Collectors.toSet());
    }

    private String makeRelative(String sourceDirectoryPrefix, String fileName) {
        return PATH_UTIL.getRelativePath(sourceDirectoryPrefix, fileName);
    }

    private boolean isInterestingFileName(String fileName, Predicate<String> skipFileNamePredicate) {
        return !"-".equals(fileName) && !skipFileNamePredicate.test(fileName);
    }
}

