/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.model;

import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.model.ClassNameRewriter;
import edu.umd.cs.findbugs.model.IdentityClassNameRewriter;
import edu.umd.cs.findbugs.util.ClassName;
import java.util.Iterator;

public abstract class ClassNameRewriterUtil {
    public static String rewriteMethodSignature(ClassNameRewriter classNameRewriter, String methodSignature) {
        if (classNameRewriter != IdentityClassNameRewriter.instance()) {
            SignatureParser parser = new SignatureParser(methodSignature);
            StringBuilder buf = new StringBuilder();
            buf.append('(');
            Iterator<String> i = parser.parameterSignatureIterator();
            while (i.hasNext()) {
                buf.append(ClassNameRewriterUtil.rewriteSignature(classNameRewriter, i.next()));
            }
            buf.append(')');
            buf.append(ClassNameRewriterUtil.rewriteSignature(classNameRewriter, parser.getReturnTypeSignature()));
            methodSignature = buf.toString();
        }
        return methodSignature;
    }

    public static String rewriteSignature(ClassNameRewriter classNameRewriter, String signature) {
        if (classNameRewriter != IdentityClassNameRewriter.instance() && ((String)signature).startsWith("L")) {
            String className = ClassName.fromFieldSignatureToDottedClassName((String)signature);
            className = classNameRewriter.rewriteClassName(className);
            signature = "L" + ClassName.toSlashedClassName(className) + ";";
        }
        return signature;
    }

    public static MethodAnnotation convertMethodAnnotation(ClassNameRewriter classNameRewriter, MethodAnnotation annotation) {
        if (classNameRewriter != IdentityClassNameRewriter.instance()) {
            annotation = new MethodAnnotation(classNameRewriter.rewriteClassName(annotation.getClassName()), annotation.getMethodName(), ClassNameRewriterUtil.rewriteMethodSignature(classNameRewriter, annotation.getMethodSignature()), annotation.isStatic());
        }
        return annotation;
    }

    public static FieldAnnotation convertFieldAnnotation(ClassNameRewriter classNameRewriter, FieldAnnotation annotation) {
        if (classNameRewriter != IdentityClassNameRewriter.instance()) {
            annotation = new FieldAnnotation(classNameRewriter.rewriteClassName(annotation.getClassName()), annotation.getFieldName(), ClassNameRewriterUtil.rewriteSignature(classNameRewriter, annotation.getFieldSignature()), annotation.isStatic());
        }
        return annotation;
    }
}

