/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.gui2.FindBugsAnalysisFileFilter;
import edu.umd.cs.findbugs.gui2.FindBugsFBAFileFilter;
import edu.umd.cs.findbugs.gui2.FindBugsFBPFileFilter;
import edu.umd.cs.findbugs.gui2.FindBugsFileFilter;
import edu.umd.cs.findbugs.gui2.FindBugsHtmlFileFilter;
import edu.umd.cs.findbugs.util.Util;
import java.io.File;

enum SaveType {
    NOT_KNOWN,
    HTML_OUTPUT,
    XML_ANALYSIS,
    FBP_FILE,
    FBA_FILE;


    public FindBugsFileFilter getFilter() {
        switch (this.ordinal()) {
            case 2: {
                return FindBugsAnalysisFileFilter.INSTANCE;
            }
            case 1: {
                return FindBugsHtmlFileFilter.INSTANCE;
            }
            case 3: {
                return FindBugsFBPFileFilter.INSTANCE;
            }
            case 4: {
                return FindBugsFBAFileFilter.INSTANCE;
            }
        }
        throw new IllegalArgumentException("No filter for type NOT_UNKNOWN");
    }

    public boolean isValid(File f) {
        if (f.isDirectory()) {
            return false;
        }
        FindBugsFileFilter filter = this.getFilter();
        return filter.accept(f);
    }

    public String getFileExtension() {
        switch (this.ordinal()) {
            case 1: {
                return ".html";
            }
            case 2: {
                return ".xml";
            }
            case 3: {
                return ".fbp";
            }
            case 4: {
                return ".fba";
            }
        }
        throw new IllegalArgumentException("No filter for type NOT_UNKNOWN");
    }

    public static SaveType forFile(File f) {
        String extension = Util.getFileExtension(f);
        if ("html".equals(extension) || "htm".equals(extension)) {
            return HTML_OUTPUT;
        }
        if ("fba".equals(extension)) {
            return FBA_FILE;
        }
        if ("fbp".equals(extension)) {
            return FBP_FILE;
        }
        if ("xml".equals(extension)) {
            return XML_ANALYSIS;
        }
        if ("html".equals(extension)) {
            return XML_ANALYSIS;
        }
        if (f.getName().toLowerCase().endsWith("xml.gz")) {
            return XML_ANALYSIS;
        }
        return NOT_KNOWN;
    }
}

