/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.internalAnnotations.SlashedClassName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.apache.bcel.classfile.Code;

public class NumberConstructor
extends OpcodeStackDetector {
    private final Map<String, Pair> boxClasses = new HashMap<String, Pair>();
    private final List<MethodDescriptor> methods = new ArrayList<MethodDescriptor>();
    private final BugAccumulator bugAccumulator;

    public NumberConstructor(BugReporter bugReporter) {
        this.bugAccumulator = new BugAccumulator(bugReporter);
        this.handle("java/lang/Byte", false, "(B)");
        this.handle("java/lang/Character", false, "(C)");
        this.handle("java/lang/Short", false, "(S)");
        this.handle("java/lang/Integer", false, "(I)");
        this.handle("java/lang/Long", false, "(J)");
        this.handle("java/lang/Float", true, "(F)");
        this.handle("java/lang/Double", true, "(D)");
    }

    private void handle(@SlashedClassName String className, boolean isFloatingPoint, String sig) {
        MethodDescriptor boxingMethod = new MethodDescriptor(className, "valueOf", sig + "L" + className + ";", true);
        MethodDescriptor parsingMethod = new MethodDescriptor(className, "valueOf", "(Ljava/lang/String;)L" + className + ";", true);
        this.boxClasses.put(className, new Pair(boxingMethod, parsingMethod));
        this.methods.add(new MethodDescriptor(className, "<init>", "(Ljava/lang/String;)V"));
        this.methods.add(new MethodDescriptor(className, "<init>", sig + "V"));
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        int majorVersion = classContext.getJavaClass().getMajor();
        if (majorVersion >= 49 && NumberConstructor.hasInterestingMethod(classContext.getJavaClass().getConstantPool(), this.methods)) {
            super.visitClassContext(classContext);
        }
    }

    @Override
    public void visit(Code obj) {
        super.visit(obj);
        this.bugAccumulator.reportAccumulatedBugs();
    }

    private boolean matchArguments(String sig1, String sig2) {
        int lastParen = sig1.indexOf(41);
        String args = sig1.substring(0, lastParen + 1);
        return sig2.startsWith(args);
    }

    @CheckForNull
    private MethodDescriptor getShouldCall() {
        String cls = this.getClassConstantOperand();
        Pair pair = this.boxClasses.get(cls);
        if (pair == null) {
            return null;
        }
        MethodDescriptor shouldCall = this.getSigConstantOperand().startsWith("(Ljava/lang/String;)") ? pair.parsingMethod : pair.boxingMethod;
        if (shouldCall == null) {
            return null;
        }
        if (this.matchArguments(this.getSigConstantOperand(), shouldCall.getSignature())) {
            return shouldCall;
        }
        return null;
    }

    @Override
    public void sawOpcode(int seen) {
        String type;
        int prio;
        if (seen != 183) {
            return;
        }
        if (!"<init>".equals(this.getNameConstantOperand())) {
            return;
        }
        String cls = this.getClassConstantOperand();
        MethodDescriptor shouldCall = this.getShouldCall();
        if (shouldCall == null) {
            return;
        }
        if ("java/lang/Float".equals(cls) || "java/lang/Double".equals(cls)) {
            prio = 3;
            type = "DM_FP_NUMBER_CTOR";
        } else {
            long value;
            prio = 2;
            Object constantValue = this.stack.getStackItem(0).getConstant();
            if (constantValue instanceof Number && ((value = ((Number)constantValue).longValue()) < -128L || value > 127L)) {
                prio = 3;
            }
            type = "DM_NUMBER_CTOR";
        }
        BugInstance bug = new BugInstance(this, type, prio).addClass(this).addMethod(this).addCalledMethod(this).addMethod(shouldCall).describe("SHOULD_CALL");
        this.bugAccumulator.accumulateBug(bug, this);
    }

    static class Pair {
        final MethodDescriptor boxingMethod;
        final MethodDescriptor parsingMethod;

        public Pair(MethodDescriptor boxingMethod, MethodDescriptor parsingMethod) {
            this.boxingMethod = boxingMethod;
            this.parsingMethod = parsingMethod;
        }
    }
}

