/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.NullnessAnnotation;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.generic.GenericSignatureParser;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;

public class InitializeNonnullFieldsInConstructor
extends OpcodeStackDetector {
    final BugReporter bugReporter;
    final HashSet<XField> initializedFields = new HashSet();
    final HashSet<XField> nonnullFields = new HashSet();
    final HashSet<XField> nonnullStaticFields = new HashSet();
    boolean secondaryConstructor;

    public InitializeNonnullFieldsInConstructor(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void setupVisitorForClass(JavaClass obj) {
        super.setupVisitorForClass(obj);
        this.nonnullFields.clear();
    }

    @Override
    public void visitAfter(JavaClass obj) {
        super.visitAfter(obj);
        this.nonnullFields.clear();
        this.nonnullStaticFields.clear();
    }

    @Override
    public void visit(Field obj) {
        super.visit(obj);
        XField f = XFactory.createXField(this);
        if (this.checkForInitialization(f) && !f.isSynthetic()) {
            if (f.isStatic()) {
                this.nonnullStaticFields.add(f);
            } else {
                this.nonnullFields.add(f);
            }
        }
    }

    public boolean checkForInitialization(XField f) {
        if (!f.isReferenceType() || f.isFinal()) {
            return false;
        }
        NullnessAnnotation annotation = AnalysisContext.currentAnalysisContext().getNullnessAnnotationDatabase().getResolvedAnnotation(f, false);
        return annotation == NullnessAnnotation.NONNULL;
    }

    @Override
    public void visit(Code code) {
        HashSet<XField> needToInitialize;
        boolean interesting;
        boolean bl = interesting = "<init>".equals(this.getMethodName()) || "<clinit>".equals(this.getMethodName());
        if (!interesting) {
            return;
        }
        this.secondaryConstructor = false;
        HashSet<XField> hashSet = needToInitialize = this.getMethod().isStatic() ? this.nonnullStaticFields : this.nonnullFields;
        if (needToInitialize.isEmpty()) {
            return;
        }
        super.visit(code);
        if (!this.secondaryConstructor && !this.initializedFields.containsAll(needToInitialize)) {
            int priority = 2;
            if (needToInitialize.size() - this.initializedFields.size() == 1 && needToInitialize.size() > 1) {
                priority = 1;
            }
            for (XField f : needToInitialize) {
                if (this.initializedFields.contains(f)) continue;
                BugInstance b = new BugInstance(this, "NP_NONNULL_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR", priority).addClassAndMethod(this).addField(f);
                this.bugReporter.reportBug(b);
            }
        }
        this.initializedFields.clear();
    }

    @Override
    public void sawOpcode(int seen) {
        if (this.secondaryConstructor) {
            return;
        }
        switch (seen) {
            case 183: {
                if (this.getMethod().isStatic() || !"<init>".equals(this.getNameConstantOperand())) break;
                if (this.isSelfOperation()) {
                    OpcodeStack.Item invokedOn = this.stack.getItemMethodInvokedOn(this);
                    if (!invokedOn.isInitialParameter() || invokedOn.getRegisterNumber() != 0) break;
                    this.secondaryConstructor = true;
                    break;
                }
                if (!this.isKotlinGeneratedConstructor()) break;
                this.secondaryConstructor = true;
                break;
            }
            case 181: {
                XField f;
                if (this.getMethod().isStatic()) {
                    return;
                }
                OpcodeStack.Item left = this.stack.getStackItem(1);
                if (!left.isInitialParameter() || left.getRegisterNumber() != 0 || !this.isSelfOperation() || (f = this.getXFieldOperand()) == null || !this.checkForInitialization(f)) break;
                this.initializedFields.add(f);
                break;
            }
            case 179: {
                XField fieldToAssign;
                OpcodeStack.Item itemToAssign;
                XField f;
                if (!this.getMethod().isStatic() || !this.isSelfOperation() || (f = this.getXFieldOperand()) == null || (itemToAssign = this.stack.getStackItem(0)) != null && (fieldToAssign = itemToAssign.getXField()) != null && (f.equals(fieldToAssign) || !this.initializedFields.contains(fieldToAssign)) || !this.checkForInitialization(f)) break;
                this.initializedFields.add(f);
                break;
            }
        }
    }

    public boolean isSelfOperation() {
        return this.getClassConstantOperand().equals(this.getClassName());
    }

    private boolean isKotlinGeneratedConstructor() {
        GenericSignatureParser signatureParser = new GenericSignatureParser(this.getMethodDescriptorOperand().getSignature());
        Iterator<String> parameterSignatureIterator = signatureParser.parameterSignatureIterator();
        String lastParameter = null;
        while (parameterSignatureIterator.hasNext()) {
            lastParameter = parameterSignatureIterator.next();
        }
        return "Lkotlin/jvm/internal/DefaultConstructorMarker;".equals(lastParameter);
    }
}

