/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import org.apache.bcel.classfile.Code;

public class FormatStringChecker
extends OpcodeStackDetector {
    final BugReporter bugReporter;
    FormatState state;
    String formatString;
    int stackDepth;
    OpcodeStack.Item[] arguments;

    public FormatStringChecker(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visit(Code code) {
        this.state = FormatState.NONE;
        super.visit(code);
        this.arguments = null;
    }

    @Override
    public void sawOpcode(int seen) {
        if (this.stack.getStackDepth() < this.stackDepth) {
            this.state = FormatState.NONE;
            this.stackDepth = 0;
            this.arguments = null;
        }
        if (seen == 189 && this.stack.getStackDepth() >= 2) {
            Object size = this.stack.getStackItem(0).getConstant();
            Object formatStr = this.stack.getStackItem(1).getConstant();
            if (size instanceof Integer && formatStr instanceof String) {
                this.arguments = new OpcodeStack.Item[((Integer)size).intValue()];
                this.formatString = (String)formatStr;
                this.state = FormatState.READY_FOR_FORMAT;
                this.stackDepth = this.stack.getStackDepth();
            }
        } else if (this.state == FormatState.READY_FOR_FORMAT && seen == 89) {
            this.state = FormatState.EXPECTING_ASSIGNMENT;
        } else if (this.state == FormatState.EXPECTING_ASSIGNMENT && this.stack.getStackDepth() == this.stackDepth + 3 && seen == 83) {
            Object pos = this.stack.getStackItem(1).getConstant();
            OpcodeStack.Item value = this.stack.getStackItem(0);
            if (pos instanceof Integer) {
                int index = (Integer)pos;
                if (index >= 0 && index < this.arguments.length) {
                    this.arguments[index] = value;
                    this.state = FormatState.READY_FOR_FORMAT;
                } else {
                    this.state = FormatState.NONE;
                }
            } else {
                this.state = FormatState.NONE;
            }
        } else if (this.state == FormatState.READY_FOR_FORMAT && (seen == 183 || seen == 182 || seen == 184 || seen == 185) && this.stack.getStackDepth() == this.stackDepth) {
            String cl = this.getClassConstantOperand();
            String nm = this.getNameConstantOperand();
            String sig = this.getSigConstantOperand();
            XMethod m = this.getXMethodOperand();
            if (((m == null || m.isVarArgs()) && sig.contains("Ljava/lang/String;[Ljava/lang/Object;)") && ("java/util/Formatter".equals(cl) && "format".equals(nm) || "java/lang/String".equals(cl) && "format".equals(nm) || "java/io/PrintStream".equals(cl) && "format".equals(nm) || "java/io/PrintStream".equals(cl) && "printf".equals(nm) || cl.endsWith("Writer") && "format".equals(nm) || cl.endsWith("Writer") && "printf".equals(nm)) || cl.endsWith("Logger") && nm.endsWith("fmt") || "([Ljava/lang/Object;)Ljava/lang/String;".equals(sig) && "java/lang/String".equals(cl) && "formatted".equals(nm)) && this.formatString.indexOf(10) >= 0) {
                this.bugReporter.reportBug(new BugInstance(this, "VA_FORMAT_STRING_USES_NEWLINE", 2).addClassAndMethod(this).addCalledMethod(this).addString(this.formatString).describe("STRING_FORMAT_STRING").addSourceLine(this));
            }
        }
    }

    static enum FormatState {
        NONE,
        READY_FOR_FORMAT,
        EXPECTING_ASSIGNMENT;

    }
}

