/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.util.MutableClasses;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class FindPublicAttributes
extends OpcodeStackDetector {
    private final BugReporter bugReporter;
    private final Set<XField> writtenFields = new HashSet<XField>();
    private final Map<XField, SourceLineAnnotation> fieldDefLineMap = new HashMap<XField, SourceLineAnnotation>();

    public FindPublicAttributes(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void sawField() {
        XField field = this.getXFieldOperand();
        if (field != null && !this.fieldDefLineMap.containsKey(field)) {
            SourceLineAnnotation sla = SourceLineAnnotation.fromVisitedInstruction(this);
            this.fieldDefLineMap.put(field, sla);
        }
    }

    @Override
    public void visit(JavaClass obj) {
        for (Method m : obj.getMethods()) {
            String methodName = m.getName();
            if (!"<init>".equals(methodName) && !"<clinit>".equals(methodName)) continue;
            this.doVisitMethod(m);
        }
    }

    @Override
    public void sawOpcode(int seen) {
        if (MutableClasses.isConstructorLikeMethod(this.getMethodName())) {
            return;
        }
        if (this.getThisClass().isEnum() || this.getClassName().indexOf(36) >= 0) {
            return;
        }
        if (seen == 181 || seen == 179) {
            XField field = this.getXFieldOperand();
            if (field == null || this.writtenFields.contains(field)) {
                return;
            }
            if (!field.getClassDescriptor().equals(this.getClassDescriptor())) {
                return;
            }
            if (!field.isPublic()) {
                return;
            }
            SourceLineAnnotation sla = this.fieldDefLineMap.containsKey(field) ? this.fieldDefLineMap.get(field) : SourceLineAnnotation.fromVisitedInstruction(this);
            this.bugReporter.reportBug(new BugInstance(this, "PA_PUBLIC_PRIMITIVE_ATTRIBUTE", 2).addClass(this).addField(field).addSourceLine(sla));
            this.writtenFields.add(field);
        } else if (seen == 83) {
            XField field = this.stack.getStackItem(2).getXField();
            if (field == null || this.writtenFields.contains(field)) {
                return;
            }
            if (!field.getClassDescriptor().equals(this.getClassDescriptor())) {
                return;
            }
            if (!field.isPublic()) {
                return;
            }
            SourceLineAnnotation sla = this.fieldDefLineMap.containsKey(field) ? this.fieldDefLineMap.get(field) : SourceLineAnnotation.fromVisitedInstruction(this);
            this.bugReporter.reportBug(new BugInstance(this, "PA_PUBLIC_ARRAY_ATTRIBUTE", 2).addClass(this).addField(field).addSourceLine(sla));
            this.writtenFields.add(field);
        } else if (seen == 185 || seen == 182) {
            XMethod xmo = this.getXMethodOperand();
            if (xmo == null) {
                return;
            }
            if (!MutableClasses.looksLikeASetter(xmo.getName())) {
                return;
            }
            XField field = this.stack.getStackItem(xmo.getNumParams()).getXField();
            if (field == null || this.writtenFields.contains(field)) {
                return;
            }
            if (field.isStatic()) {
                return;
            }
            if (!field.getClassDescriptor().equals(this.getClassDescriptor())) {
                return;
            }
            if (!field.isPublic() || !field.isReferenceType()) {
                return;
            }
            if (!MutableClasses.mutableSignature(field.getSignature())) {
                return;
            }
            SourceLineAnnotation sla = this.fieldDefLineMap.containsKey(field) ? this.fieldDefLineMap.get(field) : SourceLineAnnotation.fromVisitedInstruction(this);
            this.bugReporter.reportBug(new BugInstance(this, "PA_PUBLIC_MUTABLE_OBJECT_ATTRIBUTE", 3).addClass(this).addField(field).addSourceLine(sla));
            this.writtenFields.add(field);
        }
    }
}

