/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.NonReportingDetector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.Hierarchy2;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.FieldDescriptor;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.util.ClassName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

public class FindNoSideEffectMethods
extends OpcodeStackDetector
implements NonReportingDetector {
    private static final MethodDescriptor GET_CLASS = new MethodDescriptor("java/lang/Object", "getClass", "()Ljava/lang/Class;");
    private static final MethodDescriptor ARRAY_COPY = new MethodDescriptor("java/lang/System", "arraycopy", "(Ljava/lang/Object;ILjava/lang/Object;II)V", true);
    private static final MethodDescriptor HASH_CODE = new MethodDescriptor("java/lang/Object", "hashCode", "()I");
    private static final MethodDescriptor CLASS_GET_NAME = new MethodDescriptor("java/lang/Class", "getName", "()Ljava/lang/String;");
    private static final MethodDescriptor ARRAY_STORE_STUB_METHOD = new MethodDescriptor("java/lang/Array", "set", "(ILjava/lang/Object;)V");
    private static final MethodDescriptor FIELD_STORE_STUB_METHOD = new MethodDescriptor("java/lang/Object", "putField", "(Ljava/lang/Object;)V");
    private static final FieldDescriptor TARGET_THIS = new FieldDescriptor("java/lang/Stub", "this", "V", false);
    private static final FieldDescriptor TARGET_NEW = new FieldDescriptor("java/lang/Stub", "new", "V", false);
    private static final FieldDescriptor TARGET_OTHER = new FieldDescriptor("java/lang/Stub", "other", "V", false);
    private static final Set<String> NUMBER_CLASSES = Set.of("java/lang/Integer", "java/lang/Long", "java/lang/Double", "java/lang/Float", "java/lang/Byte", "java/lang/Short", "java/math/BigInteger", "java/math/BigDecimal");
    private static final Set<String> ALLOWED_EXCEPTIONS = Set.of("java.lang.InternalError", "java.lang.ArrayIndexOutOfBoundsException", "java.lang.StringIndexOutOfBoundsException", "java.lang.IndexOutOfBoundsException");
    private static final Set<String> NO_SIDE_EFFECT_COLLECTION_METHODS = Set.of("contains", "containsKey", "containsValue", "get", "indexOf", "lastIndexOf", "iterator", "listIterator", "isEmpty", "size", "getOrDefault", "subList", "keys", "elements", "keySet", "entrySet", "values", "stream", "firstKey", "lastKey", "headMap", "tailMap", "subMap", "peek", "mappingCount");
    private static final Set<String> OBJECT_ONLY_CLASSES = Set.of("java/lang/StringBuffer", "java/lang/StringBuilder", "java/util/regex/Matcher", "java/io/ByteArrayOutputStream", "java/util/concurrent/atomic/AtomicBoolean", "java/util/concurrent/atomic/AtomicInteger", "java/util/concurrent/atomic/AtomicLong", "java/awt/Point");
    private static final byte[][] STUB_METHODS = new byte[][]{{-79}, {3, -84}, {4, -84}, {2, -84}, {9, -83}, {11, -82}, {14, -81}, {1, -80}, {42, -80}, {43, -80}};
    private static final Set<MethodDescriptor> OBJECT_ONLY_METHODS = Set.of(ARRAY_STORE_STUB_METHOD, FIELD_STORE_STUB_METHOD, new MethodDescriptor("java/util/Iterator", "next", "()Ljava/lang/Object;"), new MethodDescriptor("java/util/Enumeration", "nextElement", "()Ljava/lang/Object;"), new MethodDescriptor("java/lang/Throwable", "fillInStackTrace", "()Ljava/lang/Throwable;"));
    private static final Set<MethodDescriptor> NO_SIDE_EFFECT_METHODS = Set.of(GET_CLASS, CLASS_GET_NAME, HASH_CODE, new MethodDescriptor("java/lang/reflect/Array", "newInstance", "(Ljava/lang/Class;I)Ljava/lang/Object;"), new MethodDescriptor("java/lang/Class", "getResource", "(Ljava/lang/String;)Ljava/net/URL;"), new MethodDescriptor("java/lang/Class", "getSimpleName", "()Ljava/lang/String;"), new MethodDescriptor("java/lang/Class", "getMethods", "()[Ljava/lang/reflect/Method;"), new MethodDescriptor("java/lang/Class", "getSuperclass", "()Ljava/lang/Class;"), new MethodDescriptor("java/lang/Runtime", "availableProcessors", "()I"), new MethodDescriptor("java/lang/Runtime", "maxMemory", "()J"), new MethodDescriptor("java/lang/Runtime", "totalMemory", "()J"), new MethodDescriptor("java/lang/Iterable", "iterator", "()Ljava/util/Iterator;"), new MethodDescriptor("java/lang/Comparable", "compareTo", "(Ljava/lang/Object;)I"), new MethodDescriptor("java/util/Arrays", "deepEquals", "([Ljava/lang/Object;[Ljava/lang/Object;)Z", true), new MethodDescriptor("java/util/Enumeration", "hasMoreElements", "()Z"), new MethodDescriptor("java/util/Iterator", "hasNext", "()Z"), new MethodDescriptor("java/util/Comparator", "compare", "(Ljava/lang/Object;Ljava/lang/Object;)I"), new MethodDescriptor("java/util/logging/LogManager", "getLogger", "(Ljava/lang/String;)Ljava/util/logging/Logger;", true), new MethodDescriptor("org/apache/log4j/LogManager", "getLogger", "(Ljava/lang/String;)Lorg/apache/log4j/Logger;", true));
    private static final Set<MethodDescriptor> NEW_OBJECT_RETURNING_METHODS = Set.of(new MethodDescriptor("java/util/Vector", "elements", "()Ljava/util/Enumeration;"), new MethodDescriptor("java/util/Hashtable", "elements", "()Ljava/util/Enumeration;"), new MethodDescriptor("java/util/Hashtable", "keys", "()Ljava/util/Enumeration;"), new MethodDescriptor("java/lang/reflect/Array", "newInstance", "(Ljava/lang/Class;I)Ljava/lang/Object;"));
    private final Map<MethodDescriptor, SideEffectStatus> statusMap = new HashMap<MethodDescriptor, SideEffectStatus>();
    private final Map<MethodDescriptor, List<MethodCall>> callGraph = new HashMap<MethodDescriptor, List<MethodCall>>();
    private final Set<MethodDescriptor> getStaticMethods = new HashSet<MethodDescriptor>();
    private final Set<MethodDescriptor> uselessVoidCandidates = new HashSet<MethodDescriptor>();
    private SideEffectStatus status;
    private ArrayList<MethodCall> calledMethods;
    private Set<ClassDescriptor> subtypes;
    private Set<Integer> finallyTargets;
    private Set<Integer> finallyExceptionRegisters;
    private boolean constructor;
    private boolean uselessVoidCandidate;
    private boolean classInit;
    private Set<FieldDescriptor> allowedFields;
    private Set<MethodDescriptor> fieldsModifyingMethods;
    private final NoSideEffectMethodsDatabase noSideEffectMethods = new NoSideEffectMethodsDatabase();

    public FindNoSideEffectMethods(BugReporter bugReporter) {
        Global.getAnalysisCache().eagerlyPutDatabase(NoSideEffectMethodsDatabase.class, this.noSideEffectMethods);
    }

    @Override
    public void visit(JavaClass obj) {
        super.visit(obj);
        this.allowedFields = new HashSet<FieldDescriptor>();
        this.fieldsModifyingMethods = new HashSet<MethodDescriptor>();
        this.subtypes = null;
        if (!obj.isFinal() && !obj.isEnum()) {
            try {
                Subtypes2 subtypes2 = AnalysisContext.currentAnalysisContext().getSubtypes2();
                this.subtypes = new HashSet<ClassDescriptor>(subtypes2.getSubtypes(this.getClassDescriptor()));
                this.subtypes.remove(this.getClassDescriptor());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    @Override
    public void visit(Method method) {
        this.constructor = method.getName().equals("<init>");
        this.classInit = method.getName().equals("<clinit>");
        this.calledMethods = new ArrayList();
        this.status = SideEffectStatus.NO_SIDE_EFFECT;
        if (FindNoSideEffectMethods.hasNoSideEffect(this.getMethodDescriptor())) {
            this.handleStatus();
            return;
        }
        if (FindNoSideEffectMethods.isObjectOnlyMethod(this.getMethodDescriptor())) {
            this.status = SideEffectStatus.OBJECT_ONLY;
        }
        if (method.isNative() || FindNoSideEffectMethods.changedArg(this.getMethodDescriptor()) != -1) {
            this.status = SideEffectStatus.SIDE_EFFECT;
            this.handleStatus();
            return;
        }
        boolean sawImplementation = false;
        if (this.classInit) {
            this.superClinitCall();
        }
        if (!(method.isStatic() || method.isPrivate() || method.isFinal() || this.constructor || this.subtypes == null)) {
            for (ClassDescriptor subtype : this.subtypes) {
                try {
                    XClass xClass = Global.getAnalysisCache().getClassAnalysis(XClass.class, subtype);
                    XMethod matchingMethod = xClass.findMatchingMethod(this.getMethodDescriptor());
                    if (matchingMethod == null) continue;
                    sawImplementation = true;
                    this.sawCall(new MethodCall(matchingMethod.getMethodDescriptor(), TARGET_THIS), false);
                }
                catch (CheckedAnalysisException e) {
                    AnalysisContext.currentAnalysisContext().getLookupFailureCallback().reportMissingClass(subtype, e);
                }
            }
        }
        if (method.isAbstract() || method.isInterface()) {
            if (!sawImplementation || this.getClassName().endsWith("Visitor") || this.getClassName().endsWith("Listener") || this.getClassName().endsWith("Builder") || this.getClassName().startsWith("java/sql/") || this.getClassName().equals("java/util/concurrent/Future") && !method.getName().startsWith("is") || this.getClassName().equals("java/lang/Process") && method.getName().equals("exitValue")) {
                this.status = SideEffectStatus.SIDE_EFFECT;
            } else if (FindNoSideEffectMethods.isObjectOnlyMethod(this.getMethodDescriptor())) {
                this.status = SideEffectStatus.OBJECT_ONLY;
            } else {
                String[] thrownExceptions = this.getXMethod().getThrownExceptions();
                if (thrownExceptions != null && thrownExceptions.length > 0) {
                    this.status = SideEffectStatus.SIDE_EFFECT;
                }
            }
        }
        if (this.status == SideEffectStatus.SIDE_EFFECT || this.status == SideEffectStatus.OBJECT_ONLY || method.isAbstract() || method.isInterface() || method.isNative()) {
            this.handleStatus();
        }
    }

    @Override
    public void visit(Field obj) {
        XField xField = this.getXField();
        if (!xField.isStatic() && (xField.isPrivate() || xField.isFinal()) && xField.isReferenceType()) {
            this.allowedFields.add(xField.getFieldDescriptor());
        }
    }

    @Override
    public void visitAfter(JavaClass obj) {
        for (MethodDescriptor method : this.fieldsModifyingMethods) {
            List<MethodCall> calls = this.callGraph.get(method);
            SideEffectStatus prevStatus = this.statusMap.get(method);
            this.status = prevStatus.toSure();
            this.calledMethods = new ArrayList();
            for (MethodCall methodCall : calls) {
                FieldDescriptor target = methodCall.getTarget();
                if (target != TARGET_NEW && target != TARGET_OTHER && target != TARGET_THIS) {
                    methodCall = this.allowedFields.contains(target) ? new MethodCall(methodCall.getMethod(), TARGET_THIS) : new MethodCall(methodCall.getMethod(), TARGET_OTHER);
                }
                this.sawCall(methodCall, false);
                if (this.status != SideEffectStatus.SIDE_EFFECT) continue;
                break;
            }
            if (this.status != prevStatus) {
                this.statusMap.put(method, this.status);
            }
            if (this.status.unsure()) {
                this.calledMethods.trimToSize();
                this.callGraph.put(method, this.calledMethods);
                continue;
            }
            this.callGraph.remove(method);
        }
        MethodDescriptor clinit = new MethodDescriptor(this.getClassName(), "<clinit>", "()V", true);
        if (!this.statusMap.containsKey(clinit)) {
            this.status = SideEffectStatus.NO_SIDE_EFFECT;
            this.calledMethods = new ArrayList();
            this.superClinitCall();
            this.statusMap.put(clinit, this.status);
            if (this.status == SideEffectStatus.UNSURE || this.status == SideEffectStatus.UNSURE_OBJECT_ONLY) {
                this.calledMethods.trimToSize();
                this.callGraph.put(clinit, this.calledMethods);
            }
        }
    }

    private void superClinitCall() {
        ClassDescriptor superclassDescriptor = this.getXClass().getSuperclassDescriptor();
        if (superclassDescriptor != null && !superclassDescriptor.getClassName().equals("java/lang/Object")) {
            this.sawCall(new MethodCall(new MethodDescriptor(superclassDescriptor.getClassName(), "<clinit>", "()V", true), TARGET_THIS), false);
        }
    }

    private void handleStatus() {
        this.statusMap.put(this.getMethodDescriptor(), this.status);
        if (this.status == SideEffectStatus.UNSURE || this.status == SideEffectStatus.UNSURE_OBJECT_ONLY) {
            this.calledMethods.trimToSize();
            this.callGraph.put(this.getMethodDescriptor(), this.calledMethods);
        } else {
            this.fieldsModifyingMethods.remove(this.getMethodDescriptor());
        }
    }

    @Override
    public void visit(Code obj) {
        this.uselessVoidCandidate = !this.classInit && !this.constructor && !this.getXMethod().isSynthetic() && Type.getReturnType((String)this.getMethodSig()) == Type.VOID;
        byte[] code = obj.getCode();
        if (code.length == 4 && (code[0] & 0xFF) == 178 && (code[3] & 0xFF) == 176) {
            this.getStaticMethods.add(this.getMethodDescriptor());
            this.handleStatus();
            return;
        }
        if (code.length <= 2 && !this.getXMethod().isStatic() && (this.getXMethod().isPublic() || this.getXMethod().isProtected()) && !this.getXMethod().isFinal() && (this.getXClass().isPublic() || this.getXClass().isProtected())) {
            for (byte[] stubMethod : STUB_METHODS) {
                if (!Arrays.equals(stubMethod, code) || !this.getClassName().endsWith("Visitor") && !this.getClassName().endsWith("Listener") && FindNoSideEffectMethods.hasOtherImplementations(this.getXMethod())) continue;
                this.status = SideEffectStatus.SIDE_EFFECT;
                this.handleStatus();
                return;
            }
        }
        if (this.statusMap.containsKey(this.getMethodDescriptor())) {
            return;
        }
        this.finallyTargets = new HashSet<Integer>();
        for (CodeException ex : this.getCode().getExceptionTable()) {
            if (ex.getCatchType() != 0) continue;
            this.finallyTargets.add(ex.getHandlerPC());
        }
        this.finallyExceptionRegisters = new HashSet<Integer>();
        try {
            super.visit(obj);
        }
        catch (EarlyExitException earlyExitException) {
            // empty catch block
        }
        if (this.uselessVoidCandidate && code.length > 1 && (this.status == SideEffectStatus.UNSURE || this.status == SideEffectStatus.NO_SIDE_EFFECT)) {
            this.uselessVoidCandidates.add(this.getMethodDescriptor());
        }
        this.handleStatus();
    }

    @Override
    public void sawOpcode(int seen) {
        OpcodeStack.Item valueItem;
        OpcodeStack.Item objItem;
        if (!this.allowedFields.isEmpty() && seen == 181 && (objItem = this.getStack().getStackItem(1)).getRegisterNumber() == 0 && this.allowedFields.contains(this.getFieldDescriptorOperand()) && !FindNoSideEffectMethods.isNew(valueItem = this.getStack().getStackItem(0)) && !valueItem.isNull()) {
            this.allowedFields.remove(this.getFieldDescriptorOperand());
        }
        if (this.status == SideEffectStatus.SIDE_EFFECT && this.allowedFields.isEmpty()) {
            throw new EarlyExitException();
        }
        if (this.status == SideEffectStatus.SIDE_EFFECT) {
            return;
        }
        switch (seen) {
            case 58: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                if (!this.finallyTargets.contains(this.getPC())) break;
                this.finallyExceptionRegisters.add(this.getRegisterOperand());
                break;
            }
            case 191: {
                OpcodeStack.Item exceptionItem = this.getStack().getStackItem(0);
                if (this.finallyExceptionRegisters.remove(exceptionItem.getRegisterNumber())) break;
                this.uselessVoidCandidate = false;
                try {
                    JavaClass javaClass = exceptionItem.getJavaClass();
                    if (javaClass != null && ALLOWED_EXCEPTIONS.contains(javaClass.getClassName())) {
                        break;
                    }
                }
                catch (ClassNotFoundException javaClass) {
                    // empty catch block
                }
                this.status = SideEffectStatus.SIDE_EFFECT;
                break;
            }
            case 179: {
                if (this.classInit && this.getClassConstantOperand().equals(this.getClassName())) break;
                this.status = SideEffectStatus.SIDE_EFFECT;
                break;
            }
            case 186: {
                this.status = SideEffectStatus.SIDE_EFFECT;
                break;
            }
            case 181: {
                this.sawCall(this.getMethodCall(FIELD_STORE_STUB_METHOD), false);
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                this.sawCall(this.getMethodCall(ARRAY_STORE_STUB_METHOD), false);
                break;
            }
            case 184: {
                if (this.changesOnlyNewObjects(this.getMethodDescriptorOperand())) break;
                this.sawCall(new MethodCall(this.getMethodDescriptorOperand(), TARGET_OTHER), false);
                break;
            }
            case 182: 
            case 183: 
            case 185: {
                MethodDescriptor methodDescriptorOperand;
                XMethod xMethodOperand = this.getXMethodOperand();
                MethodDescriptor methodDescriptor = methodDescriptorOperand = xMethodOperand == null ? this.getMethodDescriptorOperand() : xMethodOperand.getMethodDescriptor();
                if (this.changesOnlyNewObjects(this.getMethodDescriptorOperand())) break;
                MethodCall methodCall = this.getMethodCall(methodDescriptorOperand);
                this.sawCall(methodCall, false);
                break;
            }
        }
    }

    private MethodCall getMethodCall(MethodDescriptor methodDescriptorOperand) {
        OpcodeStack.Item objItem = this.getStack().getStackItem(FindNoSideEffectMethods.getNumberArguments(methodDescriptorOperand.getSignature()));
        if (FindNoSideEffectMethods.isNew(objItem)) {
            return new MethodCall(methodDescriptorOperand, TARGET_NEW);
        }
        if (objItem.getRegisterNumber() == 0 && !this.getMethod().isStatic()) {
            return new MethodCall(methodDescriptorOperand, this.constructor ? TARGET_NEW : TARGET_THIS);
        }
        XField xField = objItem.getXField();
        if (xField != null) {
            if (this.classInit && xField.isStatic() && xField.getClassDescriptor().getClassName().equals(this.getClassName())) {
                return new MethodCall(methodDescriptorOperand, TARGET_NEW);
            }
            if (!this.getMethodDescriptor().isStatic() && objItem.getFieldLoadedFromRegister() == 0 && this.allowedFields.contains(xField.getFieldDescriptor())) {
                this.fieldsModifyingMethods.add(this.getMethodDescriptor());
                return new MethodCall(methodDescriptorOperand, xField.getFieldDescriptor());
            }
        }
        return new MethodCall(methodDescriptorOperand, TARGET_OTHER);
    }

    private void sawCall(MethodCall methodCall, boolean finalPass) {
        SideEffectStatus calledStatus;
        if (this.status == SideEffectStatus.SIDE_EFFECT) {
            return;
        }
        MethodDescriptor methodDescriptor = methodCall.getMethod();
        if (FindNoSideEffectMethods.hasNoSideEffect(methodDescriptor)) {
            this.sawNoSideEffectCall(methodDescriptor);
            return;
        }
        FieldDescriptor target = methodCall.getTarget();
        SideEffectStatus sideEffectStatus = calledStatus = FindNoSideEffectMethods.isObjectOnlyMethod(methodDescriptor) ? SideEffectStatus.OBJECT_ONLY : this.statusMap.get(methodDescriptor);
        if (calledStatus == null) {
            calledStatus = finalPass ? (FindNoSideEffectMethods.hasNoSideEffectUnknown(methodDescriptor) ? SideEffectStatus.NO_SIDE_EFFECT : SideEffectStatus.SIDE_EFFECT) : SideEffectStatus.UNSURE;
        }
        switch (calledStatus.ordinal()) {
            case 4: {
                this.sawNoSideEffectCall(methodDescriptor);
                return;
            }
            case 0: {
                this.status = SideEffectStatus.SIDE_EFFECT;
                return;
            }
            case 2: {
                if (target == TARGET_THIS) {
                    this.status = this.status.toObjectOnly();
                } else if (target == TARGET_OTHER) {
                    this.status = SideEffectStatus.SIDE_EFFECT;
                } else if (target != TARGET_NEW) {
                    this.status = this.status.toObjectOnly();
                    this.sawUnsureCall(methodCall);
                }
                return;
            }
            case 1: {
                if (target == TARGET_NEW) {
                    this.sawUnsureCall(methodCall);
                } else if (target == TARGET_OTHER) {
                    this.status = SideEffectStatus.SIDE_EFFECT;
                } else {
                    this.status = this.status.toObjectOnly();
                    this.sawUnsureCall(methodCall);
                }
                return;
            }
            case 3: {
                this.sawUnsureCall(methodCall);
                return;
            }
        }
    }

    private void sawNoSideEffectCall(MethodDescriptor methodDescriptor) {
        if (this.uselessVoidCandidate && Type.getReturnType((String)methodDescriptor.getSignature()) == Type.VOID && !methodDescriptor.getName().equals("<init>")) {
            this.uselessVoidCandidate = false;
        }
    }

    private void sawUnsureCall(MethodCall methodCall) {
        this.calledMethods.add(methodCall);
        this.status = this.status.toUnsure();
    }

    private static boolean isNew(OpcodeStack.Item item) {
        if (item.isNewlyAllocated()) {
            return true;
        }
        XMethod returnValueOf = item.getReturnValueOf();
        if (returnValueOf == null) {
            return false;
        }
        return "iterator".equals(returnValueOf.getName()) && "()Ljava/util/Iterator;".equals(returnValueOf.getSignature()) && Subtypes2.instanceOf(returnValueOf.getClassName(), "java.lang.Iterable") || returnValueOf.getClassName().startsWith("[") && returnValueOf.getName().equals("clone") || NEW_OBJECT_RETURNING_METHODS.contains(returnValueOf.getMethodDescriptor());
    }

    private boolean changesOnlyNewObjects(MethodDescriptor methodDescriptor) {
        int arg = FindNoSideEffectMethods.changedArg(methodDescriptor);
        if (arg == -1) {
            return false;
        }
        int nArgs = FindNoSideEffectMethods.getNumberArguments(methodDescriptor.getSignature());
        return FindNoSideEffectMethods.isNew(this.getStack().getStackItem(nArgs - arg - 1));
    }

    private static int changedArg(MethodDescriptor m) {
        if (m.equals(ARRAY_COPY)) {
            return 2;
        }
        if (m.getName().equals("toArray") && m.getSignature().equals("([Ljava/lang/Object;)[Ljava/lang/Object;") && Subtypes2.instanceOf(m.getClassDescriptor(), "java.util.Collection")) {
            return 0;
        }
        if ((m.getName().equals("sort") || m.getName().equals("fill") || m.getName().equals("reverse") || m.getName().equals("shuffle")) && (m.getSlashedClassName().equals("java/util/Arrays") || m.getSlashedClassName().equals("java/util/Collections"))) {
            return 0;
        }
        return -1;
    }

    private static boolean hasNoSideEffect(MethodDescriptor m) {
        String className = m.getSlashedClassName();
        String methodName = m.getName();
        String methodSig = m.getSignature();
        if ("java/lang/String".equals(className)) {
            return !methodName.equals("getChars") && (!methodName.equals("getBytes") || !methodSig.equals("(II[BI)V"));
        }
        if ("java/lang/Math".equals(className)) {
            return !methodName.equals("random");
        }
        if ("java/lang/Throwable".equals(className)) {
            return methodName.startsWith("get");
        }
        if ("java/lang/Character".equals(className)) {
            return !methodName.equals("toChars");
        }
        if ("java/lang/Class".equals(className) && methodName.startsWith("is")) {
            return true;
        }
        if ("java/awt/Color".equals(className) && methodName.equals("<init>")) {
            return true;
        }
        if ("java/util/regex/Pattern".contains(className)) {
            return !methodName.equals("compile") && !methodName.equals("<init>");
        }
        if (className.startsWith("[") && methodName.equals("clone")) {
            return true;
        }
        if (className.startsWith("org/w3c/dom/") && (methodName.startsWith("get") || methodName.startsWith("has") || methodName.equals("item"))) {
            return true;
        }
        if (className.startsWith("java/util/") && (className.endsWith("Set") || className.endsWith("Map") || className.endsWith("Collection") || className.endsWith("List") || className.endsWith("Queue") || className.endsWith("Deque") || className.endsWith("Vector")) || className.endsWith("Hashtable") || className.endsWith("Dictionary")) {
            if (className.equals("java/util/LinkedHashMap") && methodName.startsWith("get")) {
                return false;
            }
            if (NO_SIDE_EFFECT_COLLECTION_METHODS.contains(methodName) || methodName.equals("toArray") && methodSig.equals("()[Ljava/lang/Object;")) {
                return true;
            }
        }
        if (methodName.equals("binarySearch") && (className.equals("java/util/Arrays") || className.equals("java/util/Collections")) || methodName.startsWith("$SWITCH_TABLE$") || methodName.equals("<init>") && FindNoSideEffectMethods.isObjectOnlyClass(className) || methodName.equals("toString") && methodSig.equals("()Ljava/lang/String;") && className.startsWith("java/")) {
            return true;
        }
        if (NUMBER_CLASSES.contains(className)) {
            return !methodSig.startsWith("(Ljava/lang/String;");
        }
        return !m.isStatic() && methodName.equals("equals") && methodSig.equals("(Ljava/lang/Object;)Z") || NO_SIDE_EFFECT_METHODS.contains(m);
    }

    private static boolean hasNoSideEffectUnknown(MethodDescriptor m) {
        switch (m.getName()) {
            case "<clinit>": {
                return m.isStatic();
            }
            case "values": {
                return m.isStatic() && m.getSignature().startsWith("()") && Subtypes2.instanceOf(m.getClassDescriptor(), "java.lang.Enum");
            }
            case "toString": {
                return !m.isStatic() && m.getSignature().equals("()Ljava/lang/String;");
            }
            case "hashCode": {
                return !m.isStatic() && m.getSignature().equals("()I");
            }
        }
        return false;
    }

    private static boolean isObjectOnlyMethod(MethodDescriptor m) {
        String methodName = m.getName();
        if (m.isStatic() || methodName.equals("<init>") || methodName.equals("forEach")) {
            return false;
        }
        String className = m.getSlashedClassName();
        return FindNoSideEffectMethods.isObjectOnlyClass(className) || className.startsWith("javax/xml/") && methodName.startsWith("next") || (className.startsWith("java/net/") || className.startsWith("javax/servlet") || className.startsWith("jakarta/servlet")) && (methodName.startsWith("remove") || methodName.startsWith("add") || methodName.startsWith("set")) || OBJECT_ONLY_METHODS.contains(m);
    }

    private static boolean isObjectOnlyClass(String className) {
        if (OBJECT_ONLY_CLASSES.contains(className)) {
            return true;
        }
        if (className.startsWith("java/lang/") && (className.endsWith("Error") || className.endsWith("Exception"))) {
            return true;
        }
        return className.startsWith("java/util/") && (className.endsWith("Set") || className.endsWith("Map") || className.endsWith("Collection") || className.endsWith("List") || className.endsWith("Queue") || className.endsWith("Deque") || className.endsWith("Vector"));
    }

    @Override
    public void report() {
        this.computeFinalStatus();
        HashSet<String> sideEffectClinit = new HashSet<String>();
        for (Map.Entry<MethodDescriptor, SideEffectStatus> entry : this.statusMap.entrySet()) {
            if (entry.getValue() != SideEffectStatus.SIDE_EFFECT || !entry.getKey().isStatic() || !entry.getKey().getName().equals("<clinit>")) continue;
            sideEffectClinit.add(entry.getKey().getSlashedClassName());
        }
        for (Map.Entry<MethodDescriptor, SideEffectStatus> entry : this.statusMap.entrySet()) {
            MethodDescriptor m = entry.getKey();
            if (entry.getValue() == SideEffectStatus.NO_SIDE_EFFECT) {
                String returnType = new SignatureParser(m.getSignature()).getReturnTypeSignature();
                if (!returnType.equals("V") || m.getName().equals("<init>")) {
                    String returnClass;
                    if (m.equals(GET_CLASS) || m.isAccessMethod() && (!(m instanceof XMethod) || ((XMethod)((Object)m)).getAccessMethodForMethod() == null) || m.getName().startsWith("jjStopStringLiteral")) continue;
                    if ((m.isStatic() || m.getName().equals("<init>")) && sideEffectClinit.contains(m.getSlashedClassName())) {
                        this.noSideEffectMethods.add(m, MethodSideEffectStatus.SE_CLINIT);
                        continue;
                    }
                    if (m.equals(CLASS_GET_NAME) || m.equals(HASH_CODE)) {
                        this.noSideEffectMethods.add(m, MethodSideEffectStatus.NSE_EX);
                        continue;
                    }
                    if (m.isStatic() && this.getStaticMethods.contains(m) && !m.getSlashedClassName().startsWith("java/") && (returnClass = ClassName.fromFieldSignatureToDottedClassName(returnType)) != null && ClassName.extractPackageName(returnClass).equals(m.getClassDescriptor().getPackageName())) {
                        this.noSideEffectMethods.add(m, MethodSideEffectStatus.NSE_EX);
                        continue;
                    }
                    this.noSideEffectMethods.add(m, MethodSideEffectStatus.NSE);
                    continue;
                }
                if (!this.uselessVoidCandidates.contains(m) || m.getName().equals("maybeForceBuilderInitialization") && m.getSignature().equals("()V")) continue;
                this.noSideEffectMethods.add(m, MethodSideEffectStatus.USELESS);
                continue;
            }
            if (entry.getValue() != SideEffectStatus.OBJECT_ONLY) continue;
            this.noSideEffectMethods.add(m, MethodSideEffectStatus.OBJ);
        }
    }

    private static boolean hasOtherImplementations(XMethod xMethod) {
        Set<XMethod> superMethods = Hierarchy2.findSuperMethods(xMethod);
        superMethods.add(xMethod);
        Subtypes2 subtypes2 = AnalysisContext.currentAnalysisContext().getSubtypes2();
        HashSet<ClassDescriptor> subtypes = new HashSet<ClassDescriptor>();
        for (XMethod superMethod : superMethods) {
            try {
                subtypes.addAll(subtypes2.getSubtypes(superMethod.getClassDescriptor()));
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        subtypes.remove(xMethod.getClassDescriptor());
        for (ClassDescriptor subtype : subtypes) {
            try {
                XClass xClass = subtype.getXClass();
                XMethod subMethod = xClass.findMatchingMethod(xMethod.getMethodDescriptor());
                if (subMethod == null || subMethod.isAbstract()) continue;
                return true;
            }
            catch (CheckedAnalysisException checkedAnalysisException) {
            }
        }
        return false;
    }

    private void computeFinalStatus() {
        MethodDescriptor method;
        boolean changed = true;
        while (changed) {
            changed = false;
            Iterator<Map.Entry<MethodDescriptor, List<MethodCall>>> iterator = this.callGraph.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<MethodDescriptor, List<MethodCall>> entry = iterator.next();
                method = entry.getKey();
                this.uselessVoidCandidate = this.uselessVoidCandidates.contains(method);
                SideEffectStatus prevStatus = this.statusMap.get(method);
                this.status = prevStatus.toSure();
                this.calledMethods = new ArrayList();
                for (MethodCall methodCall : entry.getValue()) {
                    this.sawCall(methodCall, true);
                    if (this.status != SideEffectStatus.SIDE_EFFECT) continue;
                    break;
                }
                if (!this.uselessVoidCandidate || this.status != SideEffectStatus.UNSURE && this.status != SideEffectStatus.NO_SIDE_EFFECT) {
                    this.uselessVoidCandidates.remove(method);
                }
                if (this.status == prevStatus && entry.getValue().equals(this.calledMethods)) continue;
                this.statusMap.put(method, this.status);
                if (this.status.unsure()) {
                    entry.setValue(this.calledMethods);
                } else {
                    iterator.remove();
                }
                changed = true;
            }
        }
        for (Map.Entry<MethodDescriptor, List<MethodCall>> entry : this.callGraph.entrySet()) {
            method = entry.getKey();
            this.status = this.statusMap.get(method);
            if (this.status != SideEffectStatus.UNSURE) continue;
            boolean safeCycle = true;
            for (MethodCall methodCall : entry.getValue()) {
                SideEffectStatus calledStatus = this.statusMap.get(methodCall.getMethod());
                if (calledStatus == SideEffectStatus.UNSURE || calledStatus == SideEffectStatus.NO_SIDE_EFFECT) continue;
                safeCycle = false;
                break;
            }
            if (!safeCycle) continue;
            this.statusMap.put(method, SideEffectStatus.NO_SIDE_EFFECT);
            this.uselessVoidCandidate = this.uselessVoidCandidates.contains(method);
            if (!this.uselessVoidCandidate) continue;
            for (MethodCall call : entry.getValue()) {
                XMethod xMethod;
                this.uselessVoidCandidate = false;
                if (call.getMethod().equals(method) && call.getTarget() == TARGET_THIS || method.isStatic()) {
                    this.uselessVoidCandidate = true;
                } else if (call.getMethod() instanceof XMethod && ((xMethod = (XMethod)((Object)call.getMethod())).isFinal() || !xMethod.isPublic() && !xMethod.isProtected())) {
                    this.uselessVoidCandidate = true;
                }
                if (this.uselessVoidCandidate) continue;
                break;
            }
            if (this.uselessVoidCandidate) continue;
            this.uselessVoidCandidates.remove(method);
        }
    }

    public static class NoSideEffectMethodsDatabase {
        private final Map<MethodDescriptor, MethodSideEffectStatus> map = new HashMap<MethodDescriptor, MethodSideEffectStatus>();

        void add(MethodDescriptor m, MethodSideEffectStatus s) {
            this.map.put(m, s);
        }

        @Nonnull
        public MethodSideEffectStatus status(MethodDescriptor m) {
            MethodSideEffectStatus s = this.map.get(m);
            return s == null ? MethodSideEffectStatus.SE : s;
        }

        public boolean is(MethodDescriptor m, MethodSideEffectStatus ... statuses) {
            MethodSideEffectStatus s = this.status(m);
            for (MethodSideEffectStatus status : statuses) {
                if (s != status) continue;
                return true;
            }
            return false;
        }

        public boolean hasNoSideEffect(MethodDescriptor m) {
            return this.status(m) == MethodSideEffectStatus.NSE;
        }

        public boolean useless(MethodDescriptor m) {
            return this.status(m) == MethodSideEffectStatus.USELESS;
        }

        public boolean excluded(MethodDescriptor m) {
            return this.is(m, MethodSideEffectStatus.NSE_EX, MethodSideEffectStatus.SE_CLINIT);
        }
    }

    private static enum SideEffectStatus {
        SIDE_EFFECT,
        UNSURE_OBJECT_ONLY,
        OBJECT_ONLY,
        UNSURE,
        NO_SIDE_EFFECT;


        boolean unsure() {
            return this == UNSURE || this == UNSURE_OBJECT_ONLY;
        }

        SideEffectStatus toObjectOnly() {
            switch (this.ordinal()) {
                case 3: {
                    return UNSURE_OBJECT_ONLY;
                }
                case 4: {
                    return OBJECT_ONLY;
                }
            }
            return this;
        }

        SideEffectStatus toUnsure() {
            switch (this.ordinal()) {
                case 2: {
                    return UNSURE_OBJECT_ONLY;
                }
                case 4: {
                    return UNSURE;
                }
            }
            return this;
        }

        SideEffectStatus toSure() {
            switch (this.ordinal()) {
                case 1: {
                    return OBJECT_ONLY;
                }
                case 3: {
                    return NO_SIDE_EFFECT;
                }
            }
            return this;
        }
    }

    private static class MethodCall {
        private final MethodDescriptor method;
        private final FieldDescriptor target;

        public MethodCall(MethodDescriptor method, FieldDescriptor target) {
            this.method = method;
            this.target = target;
        }

        public MethodDescriptor getMethod() {
            return this.method;
        }

        public FieldDescriptor getTarget() {
            return this.target;
        }

        public int hashCode() {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            MethodCall other = (MethodCall)obj;
            return this.method.equals(other.method) && this.target.equals(other.target);
        }
    }

    static class EarlyExitException
    extends RuntimeException {
        EarlyExitException() {
        }
    }

    public static enum MethodSideEffectStatus {
        NSE,
        NSE_EX,
        CHECK,
        USELESS,
        SE_CLINIT,
        OBJ,
        SE;

    }
}

