/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.detect.BuildStringPassthruGraph;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.bcel.classfile.Code;

public class CrossSiteScripting
extends OpcodeStackDetector {
    final BugReporter bugReporter;
    final BugAccumulator accumulator;
    private final Map<MethodDescriptor, int[]> allFileNameStringMethods;
    Map<String, OpcodeStack.Item> map = new HashMap<String, OpcodeStack.Item>();
    OpcodeStack.Item top = null;
    Pattern xmlSafe = Pattern.compile("\\p{Alnum}+");
    OpcodeStack.Item replaceTop = null;
    boolean isPlainText;

    public CrossSiteScripting(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.accumulator = new BugAccumulator(bugReporter);
        BuildStringPassthruGraph.StringPassthruDatabase database = Global.getAnalysisCache().getDatabase(BuildStringPassthruGraph.StringPassthruDatabase.class);
        this.allFileNameStringMethods = database.getFileNameStringMethods();
    }

    @Override
    public void visit(Code code) {
        this.isPlainText = false;
        super.visit(code);
        this.map.clear();
        this.accumulator.reportAccumulatedBugs();
    }

    private void annotateAndReport(BugInstance bug, OpcodeStack.Item item) {
        assert (item.isServletParameterTainted());
        String s = item.getHttpParameterName();
        int pc = item.getInjectionPC();
        if (s != null && this.xmlSafe.matcher(s).matches()) {
            bug.addString(s).describe("STRING_PARAMETER_NAME");
        }
        SourceLineAnnotation thisLine = SourceLineAnnotation.fromVisitedInstruction(this);
        if (pc >= 0) {
            SourceLineAnnotation source = SourceLineAnnotation.fromVisitedInstruction(this, pc);
            if (thisLine.getStartLine() != source.getStartLine()) {
                bug.add(source).describe("SOURCE_LINE_GENERATED_AT");
            }
        }
        bug.addOptionalLocalVariable(this, item);
        this.accumulator.accumulateBug(bug, this);
    }

    @Override
    public void sawOpcode(int seen) {
        String calledMethodSig;
        String calledClassName;
        int[] params;
        if (this.replaceTop != null) {
            this.stack.replaceTop(this.replaceTop);
            this.replaceTop = null;
        }
        OpcodeStack.Item oldTop = this.top;
        this.top = null;
        if ((seen == 183 || seen == 184 || seen == 185 || seen == 182) && (params = this.allFileNameStringMethods.get(this.getMethodDescriptorOperand())) != null) {
            int numArgs = CrossSiteScripting.getNumberArguments(this.getSigConstantOperand());
            for (int param : params) {
                OpcodeStack.Item path = this.stack.getStackItem(numArgs - 1 - param);
                if (!this.isTainted(path)) continue;
                String bugPattern = this.taintPriority(path) == 1 ? "PT_ABSOLUTE_PATH_TRAVERSAL" : "PT_RELATIVE_PATH_TRAVERSAL";
                this.annotateAndReport(new BugInstance(this, bugPattern, 2).addClassAndMethod(this).addCalledMethod(this), path);
            }
        }
        if (seen == 183) {
            calledClassName = this.getClassConstantOperand();
            String calledMethodName = this.getNameConstantOperand();
            calledMethodSig = this.getSigConstantOperand();
            if (("javax/servlet/http/Cookie".equals(calledClassName) || "jakarta/servlet/http/Cookie".equals(calledClassName)) && "<init>".equals(calledMethodName) && "(Ljava/lang/String;Ljava/lang/String;)V".equals(calledMethodSig)) {
                OpcodeStack.Item value = this.stack.getStackItem(0);
                OpcodeStack.Item name = this.stack.getStackItem(1);
                if (value.isServletParameterTainted() || name.isServletParameterTainted()) {
                    int priority = Math.min(this.taintPriority(value), this.taintPriority(name));
                    this.annotateAndReport(new BugInstance(this, "HRS_REQUEST_PARAMETER_TO_COOKIE", priority).addClassAndMethod(this), value.isServletParameterTainted() ? value : name);
                }
            }
        } else if (seen == 185) {
            OpcodeStack.Item writing;
            calledClassName = this.getClassConstantOperand();
            String calledMethodName = this.getNameConstantOperand();
            calledMethodSig = this.getSigConstantOperand();
            if (("javax/servlet/http/HttpServletResponse".equals(calledClassName) || "jakarta/servlet/http/HttpServletResponse".equals(calledClassName)) && "setContentType".equals(calledMethodName)) {
                OpcodeStack.Item writing2 = this.stack.getStackItem(0);
                if ("text/plain".equals(writing2.getConstant())) {
                    this.isPlainText = true;
                }
            } else if (("javax/servlet/http/HttpSession".equals(calledClassName) || "jakarta/servlet/http/HttpSession".equals(calledClassName)) && "setAttribute".equals(calledMethodName)) {
                OpcodeStack.Item value = this.stack.getStackItem(0);
                OpcodeStack.Item name = this.stack.getStackItem(1);
                Object nameConstant = name.getConstant();
                if (nameConstant instanceof String) {
                    this.map.put((String)nameConstant, value);
                }
            } else if (("javax/servlet/http/HttpSession".equals(calledClassName) || "jakarta/servlet/http/HttpSession".equals(calledClassName)) && "getAttribute".equals(calledMethodName)) {
                OpcodeStack.Item name = this.stack.getStackItem(0);
                Object nameConstant = name.getConstant();
                if (nameConstant instanceof String) {
                    this.top = this.map.get(nameConstant);
                    if (this.isTainted(this.top)) {
                        this.replaceTop = this.top;
                    }
                }
            } else if (("javax/servlet/http/HttpServletResponse".equals(calledClassName) || "jakarta/servlet/http/HttpServletResponse".equals(calledClassName)) && (calledMethodName.startsWith("send") || calledMethodName.endsWith("Header")) && calledMethodSig.endsWith("Ljava/lang/String;)V") && this.isTainted(writing = this.stack.getStackItem(0))) {
                if ("sendError".equals(calledMethodName)) {
                    this.annotateAndReport(new BugInstance(this, "XSS_REQUEST_PARAMETER_TO_SEND_ERROR", this.taintPriority(writing)).addClassAndMethod(this), writing);
                } else {
                    this.annotateAndReport(new BugInstance(this, "HRS_REQUEST_PARAMETER_TO_HTTP_HEADER", this.taintPriority(writing)).addClassAndMethod(this), writing);
                }
            }
        } else if (seen == 182 && !this.isPlainText) {
            calledClassName = this.getClassConstantOperand();
            String calledMethodName = this.getNameConstantOperand();
            calledMethodSig = this.getSigConstantOperand();
            if ((calledMethodName.startsWith("print") || "write".equals(calledMethodName)) && ("javax/servlet/jsp/JspWriter".equals(calledClassName) || "jakarta/servlet/jsp/JspWriter".equals(calledClassName)) && ("(Ljava/lang/Object;)V".equals(calledMethodSig) || "(Ljava/lang/String;)V".equals(calledMethodSig))) {
                OpcodeStack.Item writing = this.stack.getStackItem(0);
                if (this.isTainted(writing)) {
                    this.annotateAndReport(new BugInstance(this, "XSS_REQUEST_PARAMETER_TO_JSP_WRITER", this.taintPriority(writing)).addClassAndMethod(this), writing);
                } else if (this.isTainted(oldTop)) {
                    this.annotateAndReport(new BugInstance(this, "XSS_REQUEST_PARAMETER_TO_JSP_WRITER", 2).addClassAndMethod(this), oldTop);
                }
            } else if (calledClassName.startsWith("java/io/") && calledClassName.endsWith("Writer") && (calledMethodName.startsWith("print") || calledMethodName.startsWith("write")) && ("(Ljava/lang/Object;)V".equals(calledMethodSig) || "(Ljava/lang/String;)V".equals(calledMethodSig))) {
                OpcodeStack.Item writing = this.stack.getStackItem(0);
                OpcodeStack.Item writingTo = this.stack.getStackItem(1);
                if (this.isTainted(writing) && writingTo.isServletWriter()) {
                    this.annotateAndReport(new BugInstance(this, "XSS_REQUEST_PARAMETER_TO_SERVLET_WRITER", this.taintPriority(writing)).addClassAndMethod(this), writing);
                } else if (this.isTainted(oldTop) && writingTo.isServletWriter()) {
                    this.annotateAndReport(new BugInstance(this, "XSS_REQUEST_PARAMETER_TO_SERVLET_WRITER", 2).addClassAndMethod(this), writing);
                }
            }
        }
    }

    private boolean isTainted(OpcodeStack.Item writing) {
        if (writing == null) {
            return false;
        }
        return writing.isServletParameterTainted();
    }

    private int taintPriority(OpcodeStack.Item writing) {
        if (writing == null) {
            return 2;
        }
        XMethod method = writing.getReturnValueOf();
        if (method != null && "getParameter".equals(method.getName()) && ("javax.servlet.http.HttpServletRequest".equals(method.getClassName()) || "jakarta.servlet.http.HttpServletRequest".equals(method.getClassName()))) {
            return 1;
        }
        return 2;
    }
}

