/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.analysis;

import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.ICodeBaseEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;

public class ClassNameAndSuperclassInfo
extends ClassDescriptor {
    private final ClassDescriptor superclassDescriptor;
    private final ClassDescriptor[] interfaceDescriptorList;
    private final ICodeBaseEntry codeBaseEntry;
    private final int accessFlags;
    private final Set<ClassDescriptor> calledClassDescriptors;
    private final int majorVersion;
    private final int minorVersion;

    ClassNameAndSuperclassInfo(ClassDescriptor classDescriptor, ClassDescriptor superclassDescriptor, ClassDescriptor[] interfaceDescriptorList, ICodeBaseEntry codeBaseEntry, int accessFlags, Collection<ClassDescriptor> referencedClassDescriptorList, @Nonnull Set<ClassDescriptor> calledClassDescriptors, int majorVersion, int minorVersion) {
        super(classDescriptor.getClassName());
        this.superclassDescriptor = superclassDescriptor;
        this.interfaceDescriptorList = interfaceDescriptorList;
        this.codeBaseEntry = codeBaseEntry;
        this.accessFlags = accessFlags;
        if (calledClassDescriptors == null) {
            throw new NullPointerException("calledClassDescriptors must not be null");
        }
        this.calledClassDescriptors = calledClassDescriptors;
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public ClassDescriptor getClassDescriptor() {
        return this;
    }

    public ICodeBaseEntry getCodeBaseEntry() {
        return this.codeBaseEntry;
    }

    public ClassDescriptor[] getInterfaceDescriptorList() {
        return this.interfaceDescriptorList;
    }

    public Set<ClassDescriptor> getCalledClassDescriptors() {
        return this.calledClassDescriptors;
    }

    public ClassDescriptor getSuperclassDescriptor() {
        return this.superclassDescriptor;
    }

    private boolean isFlagSet(int flag) {
        return (this.getAccessFlags() & flag) != 0;
    }

    public boolean isFinal() {
        return this.isFlagSet(16);
    }

    public boolean isPrivate() {
        return this.isFlagSet(2);
    }

    public boolean isProtected() {
        return this.isFlagSet(4);
    }

    public boolean isPublic() {
        return this.isFlagSet(1);
    }

    public boolean isStatic() {
        return this.isFlagSet(8);
    }

    public boolean isInterface() {
        return this.isFlagSet(512);
    }

    public boolean isAbstract() {
        return this.isFlagSet(1024);
    }

    public boolean isAnnotation() {
        return this.isFlagSet(8192);
    }

    public boolean isSynthetic() {
        return this.isFlagSet(4096);
    }

    public boolean isDeprecated() {
        return this.isFlagSet(131072);
    }

    public static class Builder {
        ClassDescriptor classDescriptor;
        ClassDescriptor superclassDescriptor;
        ClassDescriptor[] interfaceDescriptorList;
        ICodeBaseEntry codeBaseEntry;
        int accessFlags;
        int majorVersion;
        int minorVersion;
        Collection<ClassDescriptor> referencedClassDescriptorList;
        Set<ClassDescriptor> calledClassDescriptors = Collections.emptySet();

        public ClassNameAndSuperclassInfo build() {
            return new ClassNameAndSuperclassInfo(this.classDescriptor, this.superclassDescriptor, this.interfaceDescriptorList, this.codeBaseEntry, this.accessFlags, this.referencedClassDescriptorList, this.calledClassDescriptors, this.majorVersion, this.minorVersion);
        }

        public void setAccessFlags(int accessFlags) {
            this.accessFlags = accessFlags;
        }

        public void setClassDescriptor(ClassDescriptor classDescriptor) {
            this.classDescriptor = classDescriptor;
        }

        public void setCodeBaseEntry(ICodeBaseEntry codeBaseEntry) {
            this.codeBaseEntry = codeBaseEntry;
        }

        public void setInterfaceDescriptorList(ClassDescriptor[] interfaceDescriptorList) {
            this.interfaceDescriptorList = interfaceDescriptorList;
        }

        public void setSuperclassDescriptor(ClassDescriptor superclassDescriptor) {
            this.superclassDescriptor = superclassDescriptor;
        }

        public void setClassfileVersion(int majorVersion, int minorVersion) {
            this.majorVersion = majorVersion;
            this.minorVersion = minorVersion;
        }

        public void setReferencedClassDescriptors(Collection<ClassDescriptor> referencedClassDescriptorList) {
            this.referencedClassDescriptorList = referencedClassDescriptorList.isEmpty() ? Collections.emptyList() : new ArrayList<ClassDescriptor>(referencedClassDescriptorList);
        }

        public void setCalledClassDescriptors(Collection<ClassDescriptor> calledClassDescriptorList) {
            this.calledClassDescriptors = calledClassDescriptorList.isEmpty() ? Collections.emptySet() : new HashSet<ClassDescriptor>(calledClassDescriptorList);
        }
    }
}

