/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.type;

import edu.umd.cs.findbugs.ba.type.ExceptionSet;
import edu.umd.cs.findbugs.ba.type.ExtendedTypes;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;

public class ExceptionObjectType
extends ObjectType
implements ExtendedTypes {
    private static final long serialVersionUID = 1L;
    private final ExceptionSet exceptionSet;

    private ExceptionObjectType(String className, ExceptionSet exceptionSet) {
        super(className);
        this.exceptionSet = exceptionSet;
    }

    public static Type fromExceptionSet(ExceptionSet exceptionSet) throws ClassNotFoundException {
        Type commonSupertype = exceptionSet.getCommonSupertype();
        if (commonSupertype.getType() != 14) {
            return commonSupertype;
        }
        ObjectType exceptionSupertype = (ObjectType)commonSupertype;
        String className = exceptionSupertype.getClassName();
        if ("java.lang.Throwable".equals(className)) {
            return exceptionSupertype;
        }
        return new ExceptionObjectType(className, exceptionSet);
    }

    public byte getType() {
        return 22;
    }

    public int hashCode() {
        return this.getSignature().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        ExceptionObjectType other = (ExceptionObjectType)o;
        return this.getSignature().equals(other.getSignature()) && this.exceptionSet.equals(other.exceptionSet);
    }

    public ExceptionSet getExceptionSet() {
        return this.exceptionSet;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("<exception:");
        boolean first = true;
        ExceptionSet.ThrownExceptionIterator i = this.exceptionSet.iterator();
        while (i.hasNext()) {
            if (first) {
                first = false;
            } else {
                buf.append(',');
            }
            buf.append(i.next().toString());
        }
        buf.append(">");
        return buf.toString();
    }
}

