/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.deref;

import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.deref.UnconditionalValueDerefAnalysis;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFactory;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import edu.umd.cs.findbugs.util.Util;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.CheckForNull;

public class UnconditionalValueDerefSet {
    private final int numValueNumbersInMethod;
    private final BitSet valueNumbersUnconditionallyDereferenced;
    private final Map<ValueNumber, Set<Location>> derefLocationSetMap;
    boolean resultsFromBackEdge = false;
    int backEdgeUpdateCount = 0;
    private int lastUpdateTimestamp;

    public UnconditionalValueDerefSet(int numValueNumbersInMethod) {
        this.numValueNumbersInMethod = numValueNumbersInMethod;
        this.valueNumbersUnconditionallyDereferenced = new BitSet();
        this.derefLocationSetMap = new HashMap<ValueNumber, Set<Location>>(3);
    }

    public boolean isBottom() {
        return this.valueNumbersUnconditionallyDereferenced.get(this.numValueNumbersInMethod);
    }

    public void setIsBottom() {
        this.clear();
        this.valueNumbersUnconditionallyDereferenced.set(this.numValueNumbersInMethod);
    }

    public boolean isTop() {
        return this.valueNumbersUnconditionallyDereferenced.get(this.numValueNumbersInMethod + 1);
    }

    public void setIsTop() {
        this.clear();
        this.valueNumbersUnconditionallyDereferenced.set(this.numValueNumbersInMethod + 1);
        this.lastUpdateTimestamp = 0;
    }

    void clear() {
        this.valueNumbersUnconditionallyDereferenced.clear();
        this.derefLocationSetMap.clear();
    }

    public void makeSameAs(UnconditionalValueDerefSet source) {
        this.valueNumbersUnconditionallyDereferenced.clear();
        this.valueNumbersUnconditionallyDereferenced.or(source.valueNumbersUnconditionallyDereferenced);
        this.lastUpdateTimestamp = source.lastUpdateTimestamp;
        this.derefLocationSetMap.clear();
        if (source.derefLocationSetMap.size() > 0) {
            for (Map.Entry<ValueNumber, Set<Location>> sourceEntry : source.derefLocationSetMap.entrySet()) {
                HashSet derefLocationSet = Util.makeSmallHashSet((Collection)sourceEntry.getValue());
                this.derefLocationSetMap.put(sourceEntry.getKey(), derefLocationSet);
            }
        }
    }

    public boolean isSameAs(UnconditionalValueDerefSet otherFact) {
        return this.valueNumbersUnconditionallyDereferenced.equals(otherFact.valueNumbersUnconditionallyDereferenced) && this.derefLocationSetMap.equals(otherFact.derefLocationSetMap);
    }

    public void mergeWith(UnconditionalValueDerefSet fact, @CheckForNull ValueNumber skipMe, ValueNumberFactory valueNumberFactory) {
        if (UnconditionalValueDerefAnalysis.DEBUG) {
            System.out.println("merge update of # " + System.identityHashCode(this) + " from " + System.identityHashCode(fact));
            System.out.println("update " + String.valueOf(this));
            System.out.println("with " + String.valueOf(fact));
        }
        boolean resultForSkippedValue = false;
        if (skipMe != null) {
            resultForSkippedValue = this.valueNumbersUnconditionallyDereferenced.get(skipMe.getNumber());
        }
        this.valueNumbersUnconditionallyDereferenced.and(fact.valueNumbersUnconditionallyDereferenced);
        if (skipMe != null) {
            this.valueNumbersUnconditionallyDereferenced.set(skipMe.getNumber(), resultForSkippedValue);
        }
        for (int i = 0; i < this.numValueNumbersInMethod; ++i) {
            ValueNumber vn = valueNumberFactory.forNumber(i);
            if (vn.equals(skipMe)) continue;
            Set<Location> factDerefLocationSet = fact.derefLocationSetMap.get(vn);
            if (this.valueNumbersUnconditionallyDereferenced.get(i)) {
                if (factDerefLocationSet == null || factDerefLocationSet.isEmpty()) continue;
                Set derefLocationSet = this.derefLocationSetMap.computeIfAbsent(vn, k -> new HashSet());
                derefLocationSet.addAll((Collection)fact.derefLocationSetMap.get(vn));
                continue;
            }
            Set<Location> removed = this.derefLocationSetMap.remove(vn);
            if (removed == null || !UnconditionalValueDerefAnalysis.DEBUG) continue;
            System.out.println("Goodbye: " + String.valueOf(removed));
        }
    }

    public void unionWith(UnconditionalValueDerefSet fact, ValueNumberFactory valueNumberFactory) {
        if (UnconditionalValueDerefAnalysis.DEBUG) {
            System.out.println("union update of # " + System.identityHashCode(this) + " from " + System.identityHashCode(fact));
        }
        this.valueNumbersUnconditionallyDereferenced.or(fact.valueNumbersUnconditionallyDereferenced);
        for (int i = 0; i < this.numValueNumbersInMethod; ++i) {
            ValueNumber vn = valueNumberFactory.forNumber(i);
            if (fact.valueNumbersUnconditionallyDereferenced.get(i)) {
                Set derefLocationSet = this.derefLocationSetMap.computeIfAbsent(vn, k -> new HashSet());
                derefLocationSet.addAll((Collection)fact.derefLocationSetMap.get(vn));
                continue;
            }
            this.derefLocationSetMap.put(vn, new HashSet<Location>(fact.getDerefLocationSet(vn)));
        }
    }

    public void addDeref(ValueNumber vn, Location location) {
        if (UnconditionalValueDerefAnalysis.DEBUG) {
            System.out.println("Adding dereference of " + String.valueOf(vn) + " to # " + System.identityHashCode(this) + " @ " + String.valueOf(location));
        }
        this.valueNumbersUnconditionallyDereferenced.set(vn.getNumber());
        Set<Location> derefLocationSet = this.getDerefLocationSet(vn);
        derefLocationSet.add(location);
    }

    public void setDerefSet(ValueNumber vn, Set<Location> derefSet) {
        if (UnconditionalValueDerefAnalysis.DEBUG) {
            System.out.println("Adding dereference of " + String.valueOf(vn) + " for # " + System.identityHashCode(this) + " to " + String.valueOf(derefSet));
        }
        this.valueNumbersUnconditionallyDereferenced.set(vn.getNumber());
        Set<Location> derefLocationSet = this.getDerefLocationSet(vn);
        derefLocationSet.clear();
        derefLocationSet.addAll(derefSet);
    }

    public void clearDerefSet(ValueNumber value) {
        if (UnconditionalValueDerefAnalysis.DEBUG) {
            System.out.println("Clearing dereference of " + String.valueOf(value) + " for # " + System.identityHashCode(this));
        }
        this.valueNumbersUnconditionallyDereferenced.clear(value.getNumber());
        this.derefLocationSetMap.remove(value);
    }

    public Set<Location> getDerefLocationSet(ValueNumber vn) {
        return this.derefLocationSetMap.computeIfAbsent(vn, k -> new HashSet());
    }

    public boolean isUnconditionallyDereferenced(ValueNumber vn) {
        return this.valueNumbersUnconditionallyDereferenced.get(vn.getNumber());
    }

    public Set<ValueNumber> getValueNumbersThatAreUnconditionallyDereferenced() {
        HashSet<ValueNumber> result = new HashSet<ValueNumber>();
        for (Map.Entry<ValueNumber, Set<Location>> e : this.derefLocationSetMap.entrySet()) {
            if (e.getValue().isEmpty()) continue;
            result.add(e.getKey());
        }
        return result;
    }

    public void retainOnlyTheseValueNumbers(Collection<ValueNumber> valueNumbers) {
        Iterator<ValueNumber> i = this.derefLocationSetMap.keySet().iterator();
        while (i.hasNext()) {
            ValueNumber v = i.next();
            if (valueNumbers.contains(v)) continue;
            i.remove();
            this.valueNumbersUnconditionallyDereferenced.clear(v.getNumber());
        }
    }

    public Set<Location> getUnconditionalDerefLocationSet(ValueNumber vn) {
        Set<Location> derefLocationSet = this.derefLocationSetMap.get(vn);
        if (derefLocationSet == null) {
            derefLocationSet = Collections.emptySet();
        }
        return derefLocationSet;
    }

    public String toString() {
        if (this.isTop()) {
            return "[TOP]";
        }
        if (this.isBottom()) {
            return "[BOTTOM]";
        }
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        boolean firstVN = true;
        for (int i = 0; i < this.numValueNumbersInMethod; ++i) {
            if (!this.valueNumbersUnconditionallyDereferenced.get(i)) continue;
            if (firstVN) {
                firstVN = false;
            } else {
                buf.append(',');
            }
            buf.append('{');
            buf.append(i);
            if (this.valueNumbersUnconditionallyDereferenced.get(i)) {
                buf.append(':');
            } else {
                buf.append('?');
            }
            TreeSet<Location> derefLocationSet = new TreeSet<Location>(this.getDerefLocationSet(i));
            boolean firstLoc = true;
            for (Location location : derefLocationSet) {
                if (firstLoc) {
                    firstLoc = false;
                } else {
                    buf.append(',');
                }
                buf.append("(" + location.getBasicBlock().getLabel() + ":" + location.getHandle().getPosition() + ")");
            }
            buf.append('}');
        }
        buf.append(']');
        return buf.toString();
    }

    private Set<Location> getDerefLocationSet(int vn) {
        for (Map.Entry<ValueNumber, Set<Location>> entry : this.derefLocationSetMap.entrySet()) {
            if (entry.getKey().getNumber() != vn) continue;
            return Collections.unmodifiableSet(entry.getValue());
        }
        return new HashSet<Location>();
    }

    public void cleanDerefSet(@CheckForNull Location location, ValueNumberFrame vnaFrame) {
        HashSet<ValueNumber> valueNumbers = new HashSet<ValueNumber>(vnaFrame.allSlots());
        valueNumbers.addAll(vnaFrame.valueNumbersForLoads());
        if (UnconditionalValueDerefAnalysis.DEBUG) {
            for (ValueNumber v : this.getValueNumbersThatAreUnconditionallyDereferenced()) {
                if (valueNumbers.contains(v)) continue;
                System.out.println("\nWhy is " + String.valueOf(v) + " unconditionally dereferenced in #" + System.identityHashCode(this));
                System.out.println("VN: " + String.valueOf(vnaFrame));
                System.out.println("UD: " + String.valueOf(this));
                System.out.println("Location: " + String.valueOf(location));
                System.out.println();
            }
        }
        this.retainOnlyTheseValueNumbers(valueNumbers);
    }

    public void setLastUpdateTimestamp(int lastUpdateTimestamp) {
        this.lastUpdateTimestamp = lastUpdateTimestamp;
    }

    public int getLastUpdateTimestamp() {
        return this.lastUpdateTimestamp;
    }

    public boolean isEmpty() {
        return this.valueNumbersUnconditionallyDereferenced.isEmpty();
    }
}

