/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.bcp;

import edu.umd.cs.findbugs.ba.bcp.PatternElement;
import edu.umd.cs.findbugs.ba.bcp.Wild;

public class ByteCodePattern {
    private PatternElement first;
    private PatternElement last;
    private int interElementWild;
    private int numElements;
    private int dummyVariableCount;

    public ByteCodePattern add(PatternElement element) {
        if (this.first != null) {
            this.addInterElementWild();
        }
        this.addElement(element);
        return this;
    }

    public ByteCodePattern addWild(int numWild) {
        Wild wild = this.isLastWild();
        if (wild != null) {
            wild.setMinAndMax(0, numWild);
        } else {
            this.addElement(new Wild(numWild));
        }
        return this;
    }

    public ByteCodePattern setInterElementWild(int numWild) {
        this.interElementWild = numWild;
        return this;
    }

    public PatternElement getFirst() {
        return this.first;
    }

    public String dummyVariable() {
        StringBuilder buf = new StringBuilder();
        buf.append("$_");
        buf.append(this.dummyVariableCount++);
        return buf.toString();
    }

    private void addInterElementWild() {
        if (this.interElementWild > 0 && this.isLastWild() == null) {
            this.addElement(new Wild(this.interElementWild));
        }
    }

    private void addElement(PatternElement element) {
        element.setIndex(this.numElements++);
        if (this.first == null) {
            this.first = this.last = element;
        } else {
            this.last.setNext(element);
            this.last = element;
        }
    }

    private Wild isLastWild() {
        if (this.last instanceof Wild) {
            return (Wild)this.last;
        }
        return null;
    }
}

