/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AccessMethodDatabase {
    private Map<MethodDescriptor, List<AccessMethodLocation>> map = new HashMap<MethodDescriptor, List<AccessMethodLocation>>();

    public void addAccessMethod(MethodDescriptor accessMethod, MethodDescriptor callerMethod, SourceLineAnnotation sourceLineAnnotation) {
        List locations = this.map.computeIfAbsent(accessMethod, k -> new ArrayList());
        locations.add(new AccessMethodLocation(callerMethod, sourceLineAnnotation));
    }

    @NonNull
    public List<AccessMethodLocation> getAccessMethodLocations(MethodDescriptor accessMethod) {
        return this.map.getOrDefault(accessMethod, Collections.emptyList());
    }

    public static class AccessMethodLocation {
        private MethodDescriptor callerMethod;
        private SourceLineAnnotation sourceLineAnnotation;

        public AccessMethodLocation(MethodDescriptor callerMethod, SourceLineAnnotation sourceLineAnnotation) {
            this.callerMethod = callerMethod;
            this.sourceLineAnnotation = sourceLineAnnotation;
        }

        public MethodDescriptor getCallerMethod() {
            return this.callerMethod;
        }

        public SourceLineAnnotation getSourceLineAnnotation() {
            return this.sourceLineAnnotation;
        }
    }
}

