/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.annotations.SuppressMatchType;
import edu.umd.cs.findbugs.detect.UselessSuppressionDetector;
import edu.umd.cs.findbugs.filter.Matcher;
import edu.umd.cs.findbugs.xml.XMLOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public abstract class WarningSuppressor
implements Matcher {
    protected static final String USELESS_SUPPRESSION_ABB = "US";
    protected static final int PRIORITY = 2;
    static final boolean DEBUG = SystemProperties.getBoolean("warning.suppressor");
    protected final String bugPattern;
    protected final SuppressMatchType matchType;
    private Set<WarningSuppressor> alternateSuppressors = Collections.emptySet();

    protected WarningSuppressor(String bugPattern, SuppressMatchType matchType) {
        this.bugPattern = bugPattern;
        this.matchType = matchType == null ? SuppressMatchType.DEFAULT : matchType;
        if (DEBUG) {
            System.out.println("Suppressing " + bugPattern);
        }
    }

    @Override
    public boolean match(BugInstance bugInstance) {
        if (DEBUG) {
            System.out.println("Checking " + String.valueOf(bugInstance));
            System.out.println("    type:" + bugInstance.getType());
            System.out.println(" against: " + this.bugPattern);
        }
        if (USELESS_SUPPRESSION_ABB.equals(bugInstance.getAbbrev())) {
            return false;
        }
        if (this.bugPattern != null) {
            switch (this.matchType) {
                case DEFAULT: {
                    if (bugInstance.getType().startsWith(this.bugPattern) || bugInstance.getBugPattern().getCategory().equalsIgnoreCase(this.bugPattern) || bugInstance.getBugPattern().getAbbrev().equalsIgnoreCase(this.bugPattern)) break;
                    return false;
                }
                case EXACT: {
                    if (bugInstance.getType().equals(this.bugPattern) || bugInstance.getBugPattern().getCategory().equals(this.bugPattern) || bugInstance.getBugPattern().getAbbrev().equals(this.bugPattern)) break;
                    return false;
                }
                case REGEX: {
                    Pattern pattern = Pattern.compile(this.bugPattern);
                    if (pattern.matcher(bugInstance.getType()).matches() || pattern.matcher(bugInstance.getBugPattern().getCategory()).matches() || pattern.matcher(bugInstance.getBugPattern().getAbbrev()).matches()) break;
                    return false;
                }
            }
        }
        if (DEBUG) {
            System.out.println(" pattern matches");
        }
        return true;
    }

    public boolean isUselessSuppressionReportable() {
        return true;
    }

    public abstract BugInstance buildUselessSuppressionBugInstance(UselessSuppressionDetector var1);

    @Override
    public void writeXML(XMLOutput xmlOutput, boolean disabled) throws IOException {
    }

    public void addAlternateSuppressors(Collection<WarningSuppressor> additionalSuppressors) {
        if (this.alternateSuppressors.isEmpty()) {
            this.alternateSuppressors = new HashSet<WarningSuppressor>(additionalSuppressors);
        } else {
            this.alternateSuppressors.addAll(additionalSuppressors);
        }
    }

    public Collection<WarningSuppressor> getAlternateSuppressors() {
        return Collections.unmodifiableCollection(this.alternateSuppressors);
    }

    protected String adjustBugPatternForMessage() {
        return this.bugPattern != null ? this.bugPattern + " " : "";
    }
}

