/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.FindBugsProgress;
import java.io.PrintStream;

public class TextUIProgressCallback
implements FindBugsProgress {
    private final PrintStream out;
    private int goal;
    private int count;
    private int numPasses;
    private int pass;

    public TextUIProgressCallback(PrintStream out) {
        this.out = out;
    }

    @Override
    public void reportNumberOfArchives(int numArchives) {
        this.goal = numArchives;
        this.count = 0;
        this.scanningArchives(0);
    }

    @Override
    public void finishArchive() {
        this.scanningArchives(++this.count);
    }

    @Override
    public void predictPassCount(int[] classesPerPass) {
        this.out.println();
        this.printMessage(classesPerPass.length + " analysis passes to perform");
        this.numPasses = classesPerPass.length;
        this.pass = 0;
    }

    @Override
    public void startAnalysis(int numClasses) {
        if (this.pass == 0) {
            this.out.println();
        }
        this.goal = numClasses;
        this.count = 0;
        this.analyzingClasses(0);
    }

    @Override
    public void finishClass() {
        this.analyzingClasses(++this.count);
    }

    @Override
    public void finishPerClassAnalysis() {
        this.out.println();
        ++this.pass;
        if (this.pass == this.numPasses) {
            this.out.println("Done with analysis");
        }
    }

    private void scanningArchives(int i) {
        String msg = String.format("Scanning archives (%d / %d)", i, this.goal);
        this.printMessage(msg);
    }

    private void analyzingClasses(int i) {
        String msg = String.format("Pass %d: Analyzing classes (%d / %d) - %02d%% complete", this.pass + 1, i, this.goal, i * 100 / this.goal);
        this.printMessage(msg);
    }

    private void printMessage(String msg) {
        if (msg.length() > 79) {
            msg = msg.substring(0, 79);
        }
        this.out.print("\r" + msg);
    }

    @Override
    public void startArchive(String name) {
    }
}

