/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;

public class SwitchHandler {
    private final List<SwitchDetails> switchOffsetStack = new ArrayList<SwitchDetails>();
    private final Set<Integer> typeSwitchPC = new HashSet<Integer>();

    public int stackSize() {
        return this.switchOffsetStack.size();
    }

    int numEnumValues(@CheckForNull XClass c) {
        if (c == null) {
            return -1;
        }
        int total = 0;
        for (XField xField : c.getXFields()) {
            if (!xField.isEnum()) continue;
            ++total;
        }
        return total;
    }

    public void enterSwitch(DismantleBytecode dbc, @CheckForNull XClass enumType) {
        int[] switchOffsets = dbc.getSwitchOffsets();
        this.enterSwitch(dbc.getOpcode(), dbc.getPC(), switchOffsets, dbc.getDefaultSwitchOffset(), switchOffsets.length == this.numEnumValues(enumType));
    }

    public void enterSwitch(int opCode, int pc, int[] switchOffsets, int defaultSwitchOffset, boolean exhaustive) {
        assert (opCode == 170 || opCode == 171);
        SwitchDetails details = new SwitchDetails(pc, switchOffsets, defaultSwitchOffset, exhaustive);
        int size = this.switchOffsetStack.size();
        while (--size >= 0) {
            SwitchDetails existingDetail = this.switchOffsetStack.get(size);
            if (details.switchPC <= existingDetail.switchPC + existingDetail.getLastOffset()) continue;
            this.switchOffsetStack.remove(size);
        }
        this.switchOffsetStack.add(details);
    }

    public boolean isOnSwitchOffset(DismantleBytecode dbc) {
        int pc = dbc.getPC();
        if (pc == this.getDefaultOffset()) {
            return false;
        }
        return pc == this.getNextSwitchOffset(dbc);
    }

    public int getNextSwitchOffset(DismantleBytecode dbc) {
        for (int size = this.switchOffsetStack.size(); size > 0; --size) {
            SwitchDetails details = this.switchOffsetStack.get(size - 1);
            int nextSwitchOffset = details.getNextSwitchOffset(dbc.getPC());
            if (nextSwitchOffset >= 0) {
                return nextSwitchOffset;
            }
            if (dbc.getPC() <= details.getDefaultOffset()) {
                return -1;
            }
            this.switchOffsetStack.remove(size - 1);
        }
        return -1;
    }

    @CheckForNull
    public SwitchDetails getNextSwitchDetails(DismantleBytecode dbc) {
        for (int size = this.switchOffsetStack.size(); size > 0; --size) {
            SwitchDetails details = this.switchOffsetStack.get(size - 1);
            int nextSwitchOffset = details.getNextSwitchOffset(dbc.getPC());
            if (nextSwitchOffset >= 0) {
                return details;
            }
            if (dbc.getPC() <= details.getDefaultOffset()) {
                return null;
            }
            this.switchOffsetStack.remove(size - 1);
        }
        return null;
    }

    public int getDefaultOffset() {
        int size = this.switchOffsetStack.size();
        if (size == 0) {
            return -1;
        }
        SwitchDetails details = this.switchOffsetStack.get(size - 1);
        return details.getDefaultOffset();
    }

    public SourceLineAnnotation getCurrentSwitchStatement(BytecodeScanningDetector detector) {
        if (this.switchOffsetStack.isEmpty()) {
            throw new IllegalStateException("No current switch statement");
        }
        SwitchDetails details = this.switchOffsetStack.get(this.switchOffsetStack.size() - 1);
        return SourceLineAnnotation.fromVisitedInstructionRange(detector.getClassContext(), detector, details.switchPC, details.switchPC + details.maxOffset - 1);
    }

    public void sawInvokeDynamic(int pc, String methodName) {
        if ("typeSwitch".equals(methodName)) {
            this.typeSwitchPC.add(pc + 5);
        }
    }

    public boolean isTypeSwitchCaseCheckCast(int opCode, int pc) {
        if (opCode != 192) {
            return false;
        }
        SwitchDetails switchDetails = this.findSwitchDetailsByPc(pc - 1, pc - 2);
        return switchDetails != null && this.typeSwitchPC.contains(switchDetails.switchPC);
    }

    public boolean isTypeSwitchCaseLoad(Location location) {
        Instruction ins = location.getHandle().getInstruction();
        if (!(ins instanceof ASTORE)) {
            return false;
        }
        BasicBlock block = location.getBasicBlock();
        InstructionHandle prev = block.getPredecessorOf(location.getHandle());
        if (prev == null) {
            return false;
        }
        if (!(prev.getInstruction() instanceof CHECKCAST)) {
            return false;
        }
        SwitchDetails switchDetails = this.findSwitchDetailsByPc(prev.getPosition() - 1, prev.getPosition() - 2);
        return switchDetails != null && this.typeSwitchPC.contains(switchDetails.switchPC);
    }

    private SwitchDetails findSwitchDetailsByPc(int ... possiblePC) {
        for (SwitchDetails switchDetails : this.switchOffsetStack) {
            for (int offset : switchDetails.swOffsets) {
                for (int pc : possiblePC) {
                    if (pc != offset + switchDetails.switchPC) continue;
                    return switchDetails;
                }
            }
        }
        return null;
    }

    public static class SwitchDetails {
        final int switchPC;
        final int[] swOffsets;
        final int defaultOffset;
        final int maxOffset;
        int nextOffset;
        final boolean exhaustive;

        public SwitchDetails(int pc, int[] offsets, int defOffset, boolean exhaustive) {
            this.switchPC = pc;
            int uniqueOffsets = 0;
            int lastValue = -1;
            int maxoffset = defOffset;
            for (int offset : offsets) {
                if (maxoffset < offset) {
                    maxoffset = offset;
                }
                if (offset == defOffset) {
                    exhaustive = false;
                }
                if (offset == lastValue) continue;
                ++uniqueOffsets;
                lastValue = offset;
            }
            this.maxOffset = maxoffset;
            this.swOffsets = new int[uniqueOffsets];
            int insertPos = 0;
            lastValue = -1;
            for (int offset1 : offsets) {
                if (offset1 == lastValue) continue;
                this.swOffsets[insertPos++] = offset1;
                lastValue = offset1;
            }
            this.defaultOffset = defOffset;
            this.nextOffset = 0;
            this.exhaustive = exhaustive;
        }

        public int getNextSwitchOffset(int currentPC) {
            while (this.nextOffset < this.swOffsets.length && currentPC > this.switchPC + this.swOffsets[this.nextOffset]) {
                ++this.nextOffset;
            }
            if (this.nextOffset >= this.swOffsets.length) {
                return -1;
            }
            return this.switchPC + this.swOffsets[this.nextOffset];
        }

        public int getDefaultOffset() {
            if (this.exhaustive) {
                return Short.MIN_VALUE;
            }
            return this.switchPC + this.defaultOffset;
        }

        private int getLastOffset() {
            return this.swOffsets.length > 0 ? this.swOffsets[this.swOffsets.length - 1] : 0;
        }

        public int getSwitchPC() {
            return this.switchPC;
        }
    }
}

