/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.charsets.UTF8;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.util.ClassName;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class ProjectPackagePrefixes {
    Map<String, PrefixFilter> map = new HashMap<String, PrefixFilter>();
    Map<Set<String>, Integer> count = new HashMap<Set<String>, Integer>();
    Map<String, Integer> missingProjectCount = new TreeMap<String, Integer>();
    Map<String, Integer> rawPackageCount = new TreeMap<String, Integer>();
    int totalCount = 0;
    static final Pattern FORBIDDEN_PACKAGE_PREFIXES = Pattern.compile(SystemProperties.getProperty("findbugs.forbiddenPackagePrefixes", " none ").replace(',', '|'));

    public int size() {
        return this.map.size();
    }

    public void countBug(BugInstance b) {
        String packageName = b.getPrimaryClass().getPackageName();
        this.countPackageMember(packageName);
    }

    public void countPackageMember(String packageName) {
        ++this.totalCount;
        TreeSet<String> results = this.getProjects(packageName);
        ProjectPackagePrefixes.incrementCount(this.count, results);
        ProjectPackagePrefixes.incrementCount(this.rawPackageCount, packageName);
        if (results.isEmpty()) {
            ProjectPackagePrefixes.incrementCount(this.missingProjectCount, packageName);
        }
    }

    public PrefixFilter getFilter(String projectName) {
        return this.map.get(projectName);
    }

    public TreeSet<String> getProjects(@DottedClassName String className) {
        TreeSet<String> results = new TreeSet<String>();
        for (Map.Entry<String, PrefixFilter> e : this.map.entrySet()) {
            if (!e.getValue().matches(className)) continue;
            results.add(e.getKey());
        }
        return results;
    }

    static <T> void incrementCount(Map<T, Integer> counter, T t) {
        ProjectPackagePrefixes.incrementCount(counter, t, 1);
    }

    static <T> void incrementCount(Map<T, Integer> counter, T t, int valueToAdd) {
        Integer v = counter.get(t);
        if (v == null) {
            counter.put(t, valueToAdd);
        } else {
            counter.put(t, v + valueToAdd);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void report() {
        void var2_6;
        System.out.println("# of items counted: " + this.totalCount);
        System.out.println("# of projects: " + this.size());
        System.out.println("By package: ");
        for (Map.Entry<String, Integer> entry : this.rawPackageCount.entrySet()) {
            String packageName = entry.getKey();
            if (entry.getValue() <= 5) continue;
            System.out.printf("%5d %s%n", entry.getValue(), packageName);
        }
        System.out.println("Count by project");
        for (Map.Entry<Object, Integer> entry : this.count.entrySet()) {
            Set projects = (Set)entry.getKey();
            if (entry.getValue() <= 5) continue;
            System.out.printf("%5d %s%n", entry.getValue(), projects);
        }
        System.out.println("Count by package for items not associated with a project");
        Set<String> packages = this.missingProjectCount.keySet();
        boolean bl = false;
        while (var2_6 < 3) {
            int num;
            HashSet<String> extraSuperPackages = new HashSet<String>();
            for (String p1 : packages) {
                int x;
                String p2;
                num = this.missingProjectCount.get(p1);
                if (num >= 3 || FORBIDDEN_PACKAGE_PREFIXES.matcher(p2 = p1.substring(0, x = p1.lastIndexOf(46))).matches()) continue;
                extraSuperPackages.add(p2);
            }
            for (String p1 : extraSuperPackages) {
                this.missingProjectCount.put(p1, 0);
            }
            Iterator<String> i = packages.iterator();
            block5: while (i.hasNext()) {
                String p1;
                p1 = i.next();
                num = this.missingProjectCount.get(p1);
                for (String p2 : packages) {
                    if (p2.length() >= p1.length() || !p1.startsWith(p2)) continue;
                    i.remove();
                    ProjectPackagePrefixes.incrementCount(this.missingProjectCount, p2, num);
                    continue block5;
                }
            }
            ++var2_6;
        }
        System.out.println("Count of missing files in packages not associated with a project");
        for (Map.Entry<String, Integer> e : this.missingProjectCount.entrySet()) {
            if (e.getValue() <= 5) continue;
            System.out.printf("%5d %s%n", e.getValue(), e.getKey());
        }
    }

    public ProjectPackagePrefixes() {
        URL u = DetectorFactoryCollection.getCoreResource("projectPaths.properties");
        if (u != null) {
            try (BufferedReader in = UTF8.bufferedReader(u.openStream());){
                String s;
                while ((s = in.readLine()) != null) {
                    String[] parts = s.split("=");
                    if (parts.length != 2 || this.map.containsKey(parts[0])) continue;
                    this.map.put(parts[0], new PrefixFilter(parts[1]));
                }
            }
            catch (IOException e1) {
                AnalysisContext.logError("Error loading projects paths", e1);
            }
        }
    }

    public static class PrefixFilter {
        final String[] parts;

        PrefixFilter(String prefixes) {
            prefixes = ClassName.toDottedClassName(prefixes).trim();
            this.parts = prefixes.isEmpty() ? new String[0] : prefixes.split("[ ,:]+");
        }

        boolean matches(@DottedClassName String className) {
            if (this.parts.length == 0) {
                return true;
            }
            for (String p : this.parts) {
                if (p.isEmpty() || !className.startsWith(p)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            String result = Arrays.asList(this.parts).toString();
            return result.substring(1, result.length() - 1);
        }
    }
}

