/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.DetectorFactoryChooser;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.PriorityAdjustment;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import java.util.HashMap;
import java.util.Map;

public class PriorityAdjuster {
    Map<String, PriorityAdjustment> adjustments = new HashMap<String, PriorityAdjustment>();
    private DetectorFactoryChooser factoryChooser;

    public PriorityAdjuster(Map<String, String> adjustments) {
        for (Map.Entry<String, String> entry : adjustments.entrySet()) {
            String target = PriorityAdjuster.checkTarget(entry.getKey());
            PriorityAdjustment priorityAdjustment = new PriorityAdjustment(entry.getValue());
            this.adjustments.put(target, priorityAdjustment);
        }
    }

    private static String checkTarget(String adjustmentTarget) {
        DetectorFactoryCollection factoryCollection = DetectorFactoryCollection.instance();
        DetectorFactory factory = factoryCollection.getFactoryByClassName(adjustmentTarget);
        if (factory != null) {
            return factory.getFullName();
        }
        factory = factoryCollection.getFactory(adjustmentTarget);
        if (factory != null) {
            return factory.getFullName();
        }
        BugPattern pattern = factoryCollection.lookupBugPattern(adjustmentTarget);
        if (pattern == null) {
            throw new IllegalArgumentException("Unknown detector or bug pattern: " + adjustmentTarget);
        }
        return adjustmentTarget;
    }

    BugInstance adjustPriority(BugInstance bugInstance) {
        int priority = bugInstance.getPriority();
        priority += this.adjustForDetector(bugInstance);
        if (!this.adjustments.isEmpty()) {
            String bugPattern;
            PriorityAdjustment patternAdjustment;
            String detectorFactoryName;
            PriorityAdjustment factoryAdjustment;
            DetectorFactory detectorFactory = bugInstance.getDetectorFactory();
            if (detectorFactory != null && (factoryAdjustment = this.adjustments.get(detectorFactoryName = detectorFactory.getFullName())) != null) {
                priority = factoryAdjustment.adjust(priority);
            }
            if ((patternAdjustment = this.adjustments.get(bugPattern = bugInstance.getBugPattern().getType())) != null) {
                priority = patternAdjustment.adjust(priority);
            }
        }
        if ((priority = BugInstance.boundedPriority(priority)) == bugInstance.getPriority()) {
            return bugInstance;
        }
        BugInstance clone = (BugInstance)bugInstance.clone();
        clone.setPriority(priority);
        return clone;
    }

    public int adjustForDetector(BugInstance bugInstance) {
        DetectorFactory factory = bugInstance.getDetectorFactory();
        if (factory != null && this.factoryChooser != null && this.factoryChooser.wasForciblyEnabled(factory)) {
            BugPattern bugPattern = bugInstance.getBugPattern();
            if (SystemProperties.ASSERTIONS_ENABLED && !"EXPERIMENTAL".equals(bugPattern.getCategory()) && !factory.getReportedBugPatterns().contains(bugPattern)) {
                AnalysisContext.logError(factory.getShortName() + " doesn't note that it reports " + String.valueOf(bugPattern) + " in category " + bugPattern.getCategory());
            }
            return 100;
        }
        return 0;
    }

    public void setFactoryChooser(@NonNull DetectorFactoryChooser factoryChooser) {
        this.factoryChooser = factoryChooser;
    }
}

