/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.AnalysisOptions;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.CheckBcel;
import edu.umd.cs.findbugs.ComponentPlugin;
import edu.umd.cs.findbugs.CurrentThreadExecutorService;
import edu.umd.cs.findbugs.DelegatingBugReporter;
import edu.umd.cs.findbugs.Detector2;
import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.DetectorFactoryChooser;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.ErrorCountingBugReporter;
import edu.umd.cs.findbugs.FilterBugReporter;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.FindBugsAnalysisFeatures;
import edu.umd.cs.findbugs.FindBugsDisplayFeatures;
import edu.umd.cs.findbugs.FindBugsProgress;
import edu.umd.cs.findbugs.FirstPassDetector;
import edu.umd.cs.findbugs.IClassScreener;
import edu.umd.cs.findbugs.IFindBugsEngine;
import edu.umd.cs.findbugs.NoClassesFoundToAnalyzeException;
import edu.umd.cs.findbugs.NoOpFindBugsProgress;
import edu.umd.cs.findbugs.Plugin;
import edu.umd.cs.findbugs.PriorityAdjuster;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SuppressionMatcher;
import edu.umd.cs.findbugs.SuppressionMatcherBugReporter;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.TextUICommandLine;
import edu.umd.cs.findbugs.Version;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.asm.FBClassReader;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.AnalysisException;
import edu.umd.cs.findbugs.ba.ObjectTypeFactory;
import edu.umd.cs.findbugs.ba.SourceInfoMap;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierAnnotation;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierApplications;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierValue;
import edu.umd.cs.findbugs.bugReporter.BugReporterDecorator;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.IAnalysisEngineRegistrar;
import edu.umd.cs.findbugs.classfile.IClassFactory;
import edu.umd.cs.findbugs.classfile.IClassObserver;
import edu.umd.cs.findbugs.classfile.IClassPath;
import edu.umd.cs.findbugs.classfile.IClassPathBuilder;
import edu.umd.cs.findbugs.classfile.ICodeBase;
import edu.umd.cs.findbugs.classfile.ICodeBaseEntry;
import edu.umd.cs.findbugs.classfile.MissingClassException;
import edu.umd.cs.findbugs.classfile.engine.bcel.EngineRegistrar;
import edu.umd.cs.findbugs.classfile.impl.ClassFactory;
import edu.umd.cs.findbugs.config.AnalysisFeatureSetting;
import edu.umd.cs.findbugs.config.UserPreferences;
import edu.umd.cs.findbugs.detect.NoteSuppressedWarnings;
import edu.umd.cs.findbugs.filter.FilterException;
import edu.umd.cs.findbugs.io.IO;
import edu.umd.cs.findbugs.log.Profiler;
import edu.umd.cs.findbugs.plan.AnalysisPass;
import edu.umd.cs.findbugs.plan.ExecutionPlan;
import edu.umd.cs.findbugs.plan.OrderingConstraintException;
import edu.umd.cs.findbugs.util.ClassName;
import edu.umd.cs.findbugs.util.TopologicalSort;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.dom4j.DocumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindBugs2
implements IFindBugsEngine,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(FindBugs2.class);
    private static final boolean LIST_ORDER = SystemProperties.getBoolean("findbugs.listOrder");
    private static final boolean VERBOSE = SystemProperties.getBoolean("findbugs.verbose");
    public static final boolean DEBUG = VERBOSE || SystemProperties.getBoolean("findbugs.debug");
    public static final boolean PROGRESS = DEBUG || SystemProperties.getBoolean("findbugs.progress");
    private static final boolean SCREEN_FIRST_PASS_CLASSES = SystemProperties.getBoolean("findbugs.screenFirstPass");
    public static final boolean MULTI_THREAD = SystemProperties.getBoolean("spotbugs.experimental.multiThread");
    public static final String PROP_FINDBUGS_HOST_APP = "findbugs.hostApp";
    public static final String PROP_FINDBUGS_HOST_APP_VERSION = "findbugs.hostAppVersion";
    private int rankThreshold;
    private List<IClassObserver> classObserverList;
    private BugReporter bugReporter;
    private ErrorCountingBugReporter errorCountingBugReporter;
    private Project project;
    private IClassFactory classFactory;
    private IClassPath classPath;
    private List<ClassDescriptor> appClassList;
    private Collection<ClassDescriptor> referencedClassSet;
    private DetectorFactoryCollection detectorFactoryCollection;
    private ExecutionPlan executionPlan;
    private String currentClassName;
    private FindBugsProgress progressReporter;
    private IClassScreener classScreener;
    private final AnalysisOptions analysisOptions = new AnalysisOptions(true);
    private final ExecutorService service;
    @Nonnull
    Set<String> explicitlyEnabledBugReporterDecorators = Collections.emptySet();
    @Nonnull
    Set<String> explicitlyDisabledBugReporterDecorators = Collections.emptySet();

    public FindBugs2() {
        this(new CurrentThreadExecutorService());
    }

    public FindBugs2(@NonNull ExecutorService service) {
        this.service = Objects.requireNonNull(service, "Given ExecutorService cannot be null.");
        this.classObserverList = new LinkedList<IClassObserver>();
        this.analysisOptions.analysisFeatureSettingList = FindBugs.DEFAULT_EFFORT;
        this.progressReporter = new NoOpFindBugsProgress();
        this.classScreener = new IClassScreener(){

            @Override
            public boolean matches(String fileName) {
                return true;
            }

            @Override
            public boolean vacuous() {
                return true;
            }
        };
        String hostApp = System.getProperty(PROP_FINDBUGS_HOST_APP);
        String hostAppVersion = null;
        if (hostApp == null || hostApp.trim().isEmpty()) {
            hostApp = "FindBugs TextUI";
            hostAppVersion = System.getProperty(PROP_FINDBUGS_HOST_APP_VERSION);
        }
        if (hostAppVersion == null) {
            hostAppVersion = "";
        }
        Version.registerApplication(hostApp, hostAppVersion);
        this.analysisOptions.scanNestedArchives = false;
        this.rankThreshold = 20;
    }

    @Override
    public void setDetectorFactoryCollection(DetectorFactoryCollection detectorFactoryCollection) {
        this.detectorFactoryCollection = detectorFactoryCollection;
    }

    @Override
    public void execute() throws IOException, InterruptedException {
        if (FindBugs.isNoAnalysis()) {
            throw new UnsupportedOperationException("This FindBugs invocation was started without analysis capabilities");
        }
        Profiler profiler = this.bugReporter.getProjectStats().getProfiler();
        try {
            try {
                this.classFactory = ClassFactory.instance();
                this.createClassPath();
                this.progressReporter.reportNumberOfArchives(this.project.getFileCount() + this.project.getNumAuxClasspathEntries());
                profiler.start(this.getClass());
                this.createAnalysisCache();
                FindBugs2.createAnalysisContext(this.project, this.appClassList, this.analysisOptions.sourceInfoFileName);
                this.buildClassPath();
                this.buildReferencedClassSet();
                FindBugs2.setAppClassList(this.appClassList);
                FindBugs.configureBugCollection(this);
                FindBugsAnalysisFeatures.setRelaxedMode(this.analysisOptions.relaxedReportingMode);
                FindBugsDisplayFeatures.setAbridgedMessages(this.analysisOptions.abridgedMessages);
                FindBugs.configureTrainingDatabases(this);
                this.configureAnalysisFeatures();
                this.createExecutionPlan();
                for (Plugin p : this.detectorFactoryCollection.plugins()) {
                    for (ComponentPlugin<BugReporterDecorator> brp : p.getComponentPlugins(BugReporterDecorator.class)) {
                        if ((!brp.isEnabledByDefault() || brp.isNamed(this.explicitlyDisabledBugReporterDecorators)) && !brp.isNamed(this.explicitlyEnabledBugReporterDecorators)) continue;
                        this.bugReporter = BugReporterDecorator.construct(brp, this.bugReporter);
                    }
                }
                if (!this.classScreener.vacuous()) {
                    this.bugReporter = new DelegatingBugReporter(this.bugReporter){

                        @Override
                        public void reportBug(@Nonnull BugInstance bugInstance) {
                            String className = bugInstance.getPrimaryClass().getClassName();
                            String resourceName = ClassName.toSlashedClassName(className) + ".class";
                            if (FindBugs2.this.classScreener.matches(resourceName)) {
                                this.getDelegate().reportBug(bugInstance);
                            }
                        }
                    };
                }
                if (this.executionPlan.isActive(NoteSuppressedWarnings.class)) {
                    SuppressionMatcher m = AnalysisContext.currentAnalysisContext().getSuppressionMatcher();
                    this.bugReporter = new SuppressionMatcherBugReporter(this.bugReporter, m);
                }
                if (this.appClassList.isEmpty()) {
                    Map<String, ICodeBaseEntry> codebase = this.classPath.getApplicationCodebaseEntries();
                    if (this.analysisOptions.noClassOk) {
                        System.err.println("No classfiles specified; output will have no warnings");
                    } else {
                        if (codebase.isEmpty()) {
                            throw new IOException("No files to analyze could be opened");
                        }
                        throw new NoClassesFoundToAnalyzeException(this.classPath);
                    }
                }
                this.analyzeApplication();
            }
            catch (CheckedAnalysisException e) {
                IOException ioe = new IOException("IOException while scanning codebases");
                ioe.initCause(e);
                throw ioe;
            }
            catch (OutOfMemoryError e) {
                System.err.println("Out of memory");
                System.err.println("Total memory: " + Runtime.getRuntime().maxMemory() / 1000000L + "M");
                System.err.println(" free memory: " + Runtime.getRuntime().freeMemory() / 1000000L + "M");
                for (String s : this.project.getFileList()) {
                    System.err.println("Analyzed: " + s);
                }
                for (String s : this.project.getAuxClasspathEntryList()) {
                    System.err.println("     Aux: " + s);
                }
                throw e;
            }
            finally {
                this.clearCaches();
                profiler.end(this.getClass());
                profiler.report();
            }
        }
        catch (IOException e) {
            this.bugReporter.reportQueuedErrors();
            throw e;
        }
    }

    protected void clearCaches() {
        DescriptorFactory.clearInstance();
        ObjectTypeFactory.clearInstance();
        TypeQualifierApplications.clearInstance();
        TypeQualifierAnnotation.clearInstance();
        TypeQualifierValue.clearInstance();
        AnalysisContext.removeCurrentAnalysisContext();
        Global.removeAnalysisCacheForCurrentThread();
        IO.close(this.classPath);
    }

    public void dispose() {
        if (this.executionPlan != null) {
            this.executionPlan.dispose();
        }
        if (this.appClassList != null) {
            this.appClassList.clear();
        }
        if (this.classObserverList != null) {
            this.classObserverList.clear();
        }
        if (this.referencedClassSet != null) {
            this.referencedClassSet.clear();
        }
        this.analysisOptions.analysisFeatureSettingList = null;
        this.bugReporter = null;
        this.classFactory = null;
        IO.close(this.classPath);
        this.classPath = null;
        this.classScreener = null;
        this.detectorFactoryCollection = null;
        this.executionPlan = null;
        this.progressReporter = null;
        IO.close(this.project);
        this.project = null;
        this.analysisOptions.userPreferences = null;
    }

    @Override
    public BugReporter getBugReporter() {
        return this.bugReporter;
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    public void addClassObserver(IClassObserver classObserver) {
        this.classObserverList.add(classObserver);
    }

    @Override
    public void addFilter(String filterFileName, boolean include) throws IOException, FilterException {
        this.bugReporter = FindBugs.configureFilter(this.bugReporter, filterFileName, include);
    }

    @Override
    public void excludeBaselineBugs(String baselineBugs) throws IOException, DocumentException {
        this.bugReporter = FindBugs.configureBaselineFilter(this.bugReporter, baselineBugs);
    }

    @Override
    public void enableTrainingInput(String trainingInputDir) {
        this.analysisOptions.trainingInputDir = trainingInputDir;
    }

    @Override
    public void enableTrainingOutput(String trainingOutputDir) {
        this.analysisOptions.trainingOutputDir = trainingOutputDir;
    }

    @Override
    public int getBugCount() {
        return this.errorCountingBugReporter.getBugCount();
    }

    @Override
    public String getCurrentClass() {
        return this.currentClassName;
    }

    @Override
    public int getErrorCount() {
        return this.errorCountingBugReporter.getErrorCount();
    }

    @Override
    public int getMissingClassCount() {
        return this.errorCountingBugReporter.getMissingClassCount();
    }

    @Override
    public String getReleaseName() {
        return this.analysisOptions.releaseName;
    }

    @Override
    public String getProjectName() {
        return this.analysisOptions.projectName;
    }

    @Override
    public void setProjectName(String name) {
        this.analysisOptions.projectName = name;
    }

    @Override
    public void setAnalysisFeatureSettings(AnalysisFeatureSetting[] settingList) {
        this.analysisOptions.analysisFeatureSettingList = settingList;
    }

    @Override
    public void setBugReporter(BugReporter bugReporter) {
        this.errorCountingBugReporter = new ErrorCountingBugReporter(bugReporter);
        this.bugReporter = this.errorCountingBugReporter;
        this.addClassObserver(bugReporter);
    }

    @Override
    public void setClassScreener(IClassScreener classScreener) {
        this.classScreener = classScreener;
    }

    @Override
    public void setProgressCallback(FindBugsProgress progressCallback) {
        this.progressReporter = progressCallback;
    }

    @Override
    public void setProject(Project project) {
        this.project = project;
    }

    @Override
    public void setRelaxedReportingMode(boolean relaxedReportingMode) {
        this.analysisOptions.relaxedReportingMode = relaxedReportingMode;
    }

    @Override
    public void setReleaseName(String releaseName) {
        this.analysisOptions.releaseName = releaseName;
    }

    @Override
    public void setSourceInfoFile(String sourceInfoFile) {
        this.analysisOptions.sourceInfoFileName = sourceInfoFile;
    }

    @Override
    public void setUserPreferences(UserPreferences userPreferences) {
        this.analysisOptions.userPreferences = userPreferences;
        this.configureFilters(userPreferences);
    }

    protected void configureFilters(UserPreferences userPreferences) {
        IllegalArgumentException deferredError = null;
        Set<Map.Entry<String, Boolean>> excludeBugFiles = userPreferences.getExcludeBugsFiles().entrySet();
        for (Map.Entry<String, Boolean> entry : excludeBugFiles) {
            if (entry.getValue() == null || !((Boolean)entry.getValue()).booleanValue()) continue;
            try {
                this.excludeBaselineBugs((String)entry.getKey());
            }
            catch (Exception exception) {
                String message = "Unable to read filter: " + (String)entry.getKey() + " : " + exception.getMessage();
                if (this.getBugReporter() != null) {
                    this.getBugReporter().logError(message, exception);
                    continue;
                }
                if (deferredError != null) continue;
                deferredError = new IllegalArgumentException(message, exception);
            }
        }
        Set<Map.Entry<String, Boolean>> includeFilterFiles = userPreferences.getIncludeFilterFiles().entrySet();
        for (Map.Entry entry : includeFilterFiles) {
            if (entry.getValue() == null || !((Boolean)entry.getValue()).booleanValue()) continue;
            try {
                this.addFilter((String)entry.getKey(), true);
            }
            catch (Exception e) {
                String message = "Unable to read filter: " + (String)entry.getKey() + " : " + e.getMessage();
                if (this.getBugReporter() != null) {
                    this.getBugReporter().logError(message, e);
                    continue;
                }
                if (deferredError != null) continue;
                deferredError = new IllegalArgumentException(message, e);
            }
        }
        Set<Map.Entry<String, Boolean>> excludeFilterFiles = userPreferences.getExcludeFilterFiles().entrySet();
        for (Map.Entry<String, Boolean> entry : excludeFilterFiles) {
            Boolean value = entry.getValue();
            if (value == null || !value.booleanValue()) continue;
            String excludeFilterFile = entry.getKey();
            try {
                this.addFilter(excludeFilterFile, false);
            }
            catch (Exception e) {
                String message = "Unable to read filter: " + excludeFilterFile + " : " + e.getMessage();
                if (this.getBugReporter() != null) {
                    this.getBugReporter().logError(message, e);
                    continue;
                }
                if (deferredError != null) continue;
                deferredError = new IllegalArgumentException(message, e);
            }
        }
        if (deferredError != null) {
            throw deferredError;
        }
    }

    @Override
    public boolean emitTrainingOutput() {
        return this.analysisOptions.trainingOutputDir != null;
    }

    @Override
    public UserPreferences getUserPreferences() {
        return this.analysisOptions.userPreferences;
    }

    private void createClassPath() {
        this.classPath = this.classFactory.createClassPath();
    }

    @Override
    public String getTrainingInputDir() {
        return this.analysisOptions.trainingInputDir;
    }

    @Override
    public String getTrainingOutputDir() {
        return this.analysisOptions.trainingOutputDir;
    }

    @Override
    public boolean useTrainingInput() {
        return this.analysisOptions.trainingInputDir != null;
    }

    @Override
    public void setScanNestedArchives(boolean scanNestedArchives) {
        this.analysisOptions.scanNestedArchives = scanNestedArchives;
    }

    @Override
    public void setNoClassOk(boolean noClassOk) {
        this.analysisOptions.noClassOk = noClassOk;
    }

    protected IAnalysisCache createAnalysisCache() throws IOException {
        IAnalysisCache analysisCache = ClassFactory.instance().createAnalysisCache(this.classPath, this.bugReporter);
        FindBugs2.registerBuiltInAnalysisEngines(analysisCache);
        FindBugs2.registerPluginAnalysisEngines(this.detectorFactoryCollection, analysisCache);
        analysisCache.eagerlyPutDatabase(DetectorFactoryCollection.class, this.detectorFactoryCollection);
        Global.setAnalysisCacheForCurrentThread(analysisCache);
        return analysisCache;
    }

    public static void registerBuiltInAnalysisEngines(IAnalysisCache analysisCache) {
        new edu.umd.cs.findbugs.classfile.engine.EngineRegistrar().registerAnalysisEngines(analysisCache);
        new edu.umd.cs.findbugs.classfile.engine.asm.EngineRegistrar().registerAnalysisEngines(analysisCache);
        new EngineRegistrar().registerAnalysisEngines(analysisCache);
    }

    public static void registerPluginAnalysisEngines(DetectorFactoryCollection detectorFactoryCollection, IAnalysisCache analysisCache) throws IOException {
        Iterator<Plugin> i = detectorFactoryCollection.pluginIterator();
        while (i.hasNext()) {
            Plugin plugin = i.next();
            Class<? extends IAnalysisEngineRegistrar> engineRegistrarClass = plugin.getEngineRegistrarClass();
            if (engineRegistrarClass == null) continue;
            try {
                IAnalysisEngineRegistrar engineRegistrar = engineRegistrarClass.newInstance();
                engineRegistrar.registerAnalysisEngines(analysisCache);
            }
            catch (IllegalAccessException | InstantiationException e) {
                IOException ioe = new IOException("Could not create analysis engine registrar for plugin " + plugin.getPluginId());
                ioe.initCause(e);
                throw ioe;
            }
        }
    }

    private void buildClassPath() throws InterruptedException, IOException, CheckedAnalysisException {
        IClassPathBuilder builder = this.classFactory.createClassPathBuilder(this.bugReporter);
        HashSet<String> seen = new HashSet<String>();
        for (String path : this.project.getFileArray()) {
            if (!seen.add(path)) continue;
            builder.addCodeBase(this.classFactory.createFilesystemCodeBaseLocator(path), true);
        }
        for (String path : this.project.getAuxClasspathEntryList()) {
            if (!seen.add(path)) continue;
            builder.addCodeBase(this.classFactory.createFilesystemCodeBaseLocator(path), false);
        }
        builder.scanNestedArchives(this.analysisOptions.scanNestedArchives);
        builder.build(this.classPath, this.progressReporter);
        this.appClassList = builder.getAppClassList();
        if (PROGRESS) {
            System.out.println(this.appClassList.size() + " classes scanned");
        }
        ArrayList<String> pathNames = new ArrayList<String>();
        Iterator<? extends ICodeBase> i = this.classPath.appCodeBaseIterator();
        while (i.hasNext()) {
            String pathName;
            ICodeBase appCodeBase = i.next();
            if (appCodeBase.containsSourceFiles() && (pathName = appCodeBase.getPathName()) != null) {
                pathNames.add(pathName);
            }
            this.project.addTimestamp(appCodeBase.getLastModifiedTime());
        }
        this.project.addSourceDirs(pathNames);
    }

    private void buildReferencedClassSet() throws InterruptedException {
        if (PROGRESS) {
            System.out.println("Adding referenced classes");
        }
        HashSet<String> referencedPackageSet = new HashSet<String>();
        LinkedList<ClassDescriptor> workList = new LinkedList<ClassDescriptor>(this.appClassList);
        HashSet<ClassDescriptor> seen = new HashSet<ClassDescriptor>();
        HashSet<ClassDescriptor> appClassSet = new HashSet<ClassDescriptor>(this.appClassList);
        HashSet<ClassDescriptor> badAppClassSet = new HashSet<ClassDescriptor>();
        HashSet<ClassDescriptor> knownDescriptors = new HashSet<ClassDescriptor>(DescriptorFactory.instance().getAllClassDescriptors());
        int count = 0;
        HashSet<ClassDescriptor> addedToWorkList = new HashSet<ClassDescriptor>(this.appClassList);
        while (!workList.isEmpty()) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            ClassDescriptor classDesc = workList.removeFirst();
            if (seen.contains(classDesc)) continue;
            seen.add(classDesc);
            if (!knownDescriptors.contains(classDesc) && PROGRESS && ++count % 5000 == 0) {
                System.out.println("Adding referenced class " + String.valueOf(classDesc));
            }
            referencedPackageSet.add(classDesc.getPackageName());
            try {
                XClass classNameAndInfo = Global.getAnalysisCache().getClassAnalysis(XClass.class, classDesc);
                ClassDescriptor superclassDescriptor = classNameAndInfo.getSuperclassDescriptor();
                if (superclassDescriptor != null && addedToWorkList.add(superclassDescriptor)) {
                    workList.addLast(superclassDescriptor);
                }
                for (ClassDescriptor ifaceDesc : classNameAndInfo.getInterfaceDescriptorList()) {
                    if (!addedToWorkList.add(ifaceDesc)) continue;
                    workList.addLast(ifaceDesc);
                }
                ClassDescriptor enclosingClass = classNameAndInfo.getImmediateEnclosingClass();
                if (enclosingClass == null || !addedToWorkList.add(enclosingClass)) continue;
                workList.addLast(enclosingClass);
            }
            catch (RuntimeException e) {
                this.bugReporter.logError("Error scanning " + String.valueOf(classDesc) + " for referenced classes", e);
                if (!appClassSet.contains(classDesc)) continue;
                badAppClassSet.add(classDesc);
            }
            catch (MissingClassException e) {
                this.bugReporter.reportMissingClass(e.getClassDescriptor());
                if (!appClassSet.contains(classDesc)) continue;
                badAppClassSet.add(classDesc);
            }
            catch (CheckedAnalysisException e) {
                this.bugReporter.logError("Error scanning " + String.valueOf(classDesc) + " for referenced classes", e);
                if (!appClassSet.contains(classDesc)) continue;
                badAppClassSet.add(classDesc);
            }
        }
        this.appClassList.removeAll(badAppClassSet);
        DescriptorFactory.instance().purge(badAppClassSet);
        for (ClassDescriptor d : DescriptorFactory.instance().getAllClassDescriptors()) {
            referencedPackageSet.add(d.getPackageName());
        }
        this.referencedClassSet = new ArrayList<ClassDescriptor>(DescriptorFactory.instance().getAllClassDescriptors());
        if (PROGRESS) {
            referencedPackageSet.remove("");
            System.out.println("Added " + count + " referenced classes");
            System.out.println("Total of " + referencedPackageSet.size() + " packages");
            for (ClassDescriptor d : this.referencedClassSet) {
                System.out.println("  " + String.valueOf(d));
            }
        }
    }

    public List<ClassDescriptor> sortByCallGraph(Collection<ClassDescriptor> classList, TopologicalSort.OutEdges<ClassDescriptor> outEdges) {
        List<ClassDescriptor> evaluationOrder = TopologicalSort.sortByCallGraph(classList, outEdges);
        TopologicalSort.countBadEdges(evaluationOrder, outEdges);
        return evaluationOrder;
    }

    public static void clearAnalysisContext() {
        AnalysisContext.removeCurrentAnalysisContext();
    }

    public static void createAnalysisContext(Project project, List<ClassDescriptor> appClassList, @CheckForNull String sourceInfoFileName) throws IOException {
        AnalysisContext analysisContext = new AnalysisContext(project);
        AnalysisContext.setCurrentAnalysisContext(analysisContext);
        analysisContext.clearRepository();
        if (sourceInfoFileName != null) {
            SourceInfoMap sourceInfoMap = analysisContext.getSourceInfoMap();
            sourceInfoMap.read(Files.newInputStream(Path.of(sourceInfoFileName, new String[0]), new OpenOption[0]));
        }
    }

    public static void setAppClassList(List<ClassDescriptor> appClassList) {
        AnalysisContext analysisContext = AnalysisContext.currentAnalysisContext();
        analysisContext.setAppClassList(appClassList);
    }

    private void configureAnalysisFeatures() {
        for (AnalysisFeatureSetting setting : this.analysisOptions.analysisFeatureSettingList) {
            setting.configure(AnalysisContext.currentAnalysisContext());
        }
        AnalysisContext.currentAnalysisContext().setBoolProperty(7, this.analysisOptions.mergeSimilarWarnings);
    }

    private void createExecutionPlan() throws OrderingConstraintException {
        this.executionPlan = new ExecutionPlan();
        DetectorFactoryChooser detectorFactoryChooser = new DetectorFactoryChooser(){
            HashSet<DetectorFactory> forcedEnabled = new HashSet();

            @Override
            public boolean choose(DetectorFactory factory) {
                boolean result;
                boolean bl = result = FindBugs.isDetectorEnabled(FindBugs2.this, factory, FindBugs2.this.rankThreshold) || this.forcedEnabled.contains(factory);
                if (ExecutionPlan.DEBUG) {
                    System.out.printf("  %6s %s %n", result, factory.getShortName());
                }
                return result;
            }

            @Override
            public void enable(DetectorFactory factory) {
                this.forcedEnabled.add(factory);
            }

            @Override
            public boolean wasForciblyEnabled(DetectorFactory factory) {
                return this.forcedEnabled.contains(factory);
            }
        };
        this.executionPlan.setDetectorFactoryChooser(detectorFactoryChooser);
        if (ExecutionPlan.DEBUG) {
            System.out.println("rank threshold is " + this.rankThreshold);
        }
        Iterator<Plugin> i = this.detectorFactoryCollection.pluginIterator();
        while (i.hasNext()) {
            Plugin plugin = i.next();
            if (DEBUG) {
                System.out.println("Adding plugin " + plugin.getPluginId() + " to execution plan");
            }
            this.executionPlan.addPlugin(plugin);
        }
        this.executionPlan.build();
        Global.getAnalysisCache().eagerlyPutDatabase(ExecutionPlan.class, this.executionPlan);
        if (PROGRESS) {
            System.out.println(this.executionPlan.getNumPasses() + " passes in execution plan");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeApplication() throws InterruptedException {
        int passCount = 0;
        Profiler profiler = this.bugReporter.getProjectStats().getProfiler();
        PriorityAdjuster priorityAdjuster = this.bugReporter.getPriorityAdjuster();
        if (priorityAdjuster != null) {
            priorityAdjuster.setFactoryChooser(this.executionPlan.getFactoryChooser());
        }
        profiler.start(this.getClass());
        AnalysisContext.currentXFactory().canonicalizeAll();
        try {
            boolean multiplePasses;
            boolean bl = multiplePasses = this.executionPlan.getNumPasses() > 1;
            if (this.executionPlan.getNumPasses() == 0) {
                throw new AssertionError((Object)"no analysis passes");
            }
            int[] classesPerPass = new int[this.executionPlan.getNumPasses()];
            classesPerPass[0] = this.referencedClassSet.size();
            for (int i = 0; i < classesPerPass.length; ++i) {
                classesPerPass[i] = i == 0 ? this.referencedClassSet.size() : this.appClassList.size();
            }
            this.progressReporter.predictPassCount(classesPerPass);
            XFactory factory = AnalysisContext.currentXFactory();
            LinkedList<ClassDescriptor> badClasses = new LinkedList<ClassDescriptor>();
            for (ClassDescriptor desc : this.referencedClassSet) {
                try {
                    XClass info = Global.getAnalysisCache().getClassAnalysis(XClass.class, desc);
                    factory.intern(info);
                }
                catch (CheckedAnalysisException e2) {
                    AnalysisContext.currentAnalysisContext().getLookupFailureCallback().reportMissingClass(desc, e2);
                    badClasses.add(desc);
                }
            }
            if (!badClasses.isEmpty()) {
                this.referencedClassSet = new LinkedHashSet<ClassDescriptor>(this.referencedClassSet);
                this.referencedClassSet.removeAll(badClasses);
            }
            long startTime = System.currentTimeMillis();
            this.bugReporter.getProjectStats().setReferencedClasses(this.referencedClassSet.size());
            Iterator<AnalysisPass> passIterator = this.executionPlan.passIterator();
            while (passIterator.hasNext()) {
                AnalysisPass pass = passIterator.next();
                boolean isNonReportingFirstPass = multiplePasses && passCount == 0;
                Detector2[] detectorList = pass.instantiateDetector2sInPass(this.bugReporter);
                Collection<ClassDescriptor> classCollection = isNonReportingFirstPass ? this.referencedClassSet : this.appClassList;
                AnalysisContext.currentXFactory().canonicalizeAll();
                if (PROGRESS || LIST_ORDER) {
                    System.out.printf("%6d : Pass %d: %d classes%n", (System.currentTimeMillis() - startTime) / 1000L, passCount, classCollection.size());
                    if (DEBUG) {
                        XFactory.profile();
                    }
                }
                if (!isNonReportingFirstPass) {
                    TopologicalSort.OutEdges<ClassDescriptor> outEdges = e -> {
                        try {
                            XClass classNameAndInfo = Global.getAnalysisCache().getClassAnalysis(XClass.class, (ClassDescriptor)e);
                            return classNameAndInfo.getCalledClassDescriptors();
                        }
                        catch (CheckedAnalysisException e2) {
                            AnalysisContext.logError("error while analyzing " + e.getClassName(), e2);
                            return Collections.emptyList();
                        }
                    };
                    classCollection = this.sortByCallGraph(classCollection, outEdges);
                }
                if (LIST_ORDER) {
                    System.out.println("Analysis order:");
                    for (ClassDescriptor c : classCollection) {
                        System.out.println("  " + String.valueOf(c));
                    }
                }
                AnalysisContext currentAnalysisContext = AnalysisContext.currentAnalysisContext();
                currentAnalysisContext.updateDatabases(passCount);
                this.progressReporter.startAnalysis(classCollection.size());
                int count = 0;
                Global.getAnalysisCache().purgeAllMethodAnalysis();
                Global.getAnalysisCache().purgeClassAnalysis(FBClassReader.class);
                for (ClassDescriptor classDescriptor : classCollection) {
                    int classSize;
                    long speed;
                    long usecs;
                    long classStartNanoTime = 0L;
                    if (PROGRESS) {
                        classStartNanoTime = System.nanoTime();
                        System.out.printf("%6d %d/%d  %d/%d %s%n", (System.currentTimeMillis() - startTime) / 1000L, passCount, this.executionPlan.getNumPasses(), count, classCollection.size(), classDescriptor);
                    }
                    ++count;
                    if (!(!SCREEN_FIRST_PASS_CLASSES && isNonReportingFirstPass || this.classScreener.matches(classDescriptor.toResourceName()))) {
                        if (!DEBUG) continue;
                        System.out.println("*** Excluded by class screener");
                        continue;
                    }
                    boolean isHuge = currentAnalysisContext.isTooBig(classDescriptor);
                    if (isHuge && currentAnalysisContext.isApplicationClass(classDescriptor)) {
                        this.bugReporter.reportBug(new BugInstance("SKIPPED_CLASS_TOO_BIG", 2).addClass(classDescriptor));
                    }
                    this.currentClassName = ClassName.toDottedClassName(classDescriptor.getClassName());
                    this.notifyClassObservers(classDescriptor);
                    profiler.startContext(this.currentClassName);
                    currentAnalysisContext.setClassBeingAnalyzed(classDescriptor);
                    try {
                        Collection tasks = Arrays.stream(detectorList).map(detector -> () -> {
                            if (Thread.interrupted()) {
                                throw new InterruptedException();
                            }
                            if (isHuge && !FirstPassDetector.class.isAssignableFrom(detector.getClass())) {
                                return null;
                            }
                            LOG.debug("Applying {} to {}", (Object)detector.getDetectorClassName(), (Object)classDescriptor);
                            try {
                                profiler.start(detector.getClass());
                                detector.visitClass(classDescriptor);
                            }
                            catch (MissingClassException e) {
                                Global.getAnalysisCache().getErrorLogger().reportMissingClass(e.getClassDescriptor());
                            }
                            catch (CheckedAnalysisException | RuntimeException e) {
                                this.logRecoverableException(classDescriptor, (Detector2)detector, e);
                            }
                            finally {
                                profiler.end(detector.getClass());
                            }
                            return null;
                        }).collect(Collectors.toList());
                        this.service.invokeAll(tasks).forEach(future -> {
                            try {
                                future.get();
                            }
                            catch (InterruptedException e) {
                                LOG.warn("Thread interrupted during analysis", (Throwable)e);
                                Thread.currentThread().interrupt();
                            }
                            catch (ExecutionException e) {
                                throw new AnalysisException("Exception was thrown during analysis", e);
                            }
                        });
                        if (Thread.interrupted()) {
                            throw new InterruptedException();
                        }
                        this.progressReporter.finishClass();
                        profiler.endContext(this.currentClassName);
                        currentAnalysisContext.clearClassBeingAnalyzed();
                    }
                    catch (Throwable throwable) {
                        int classSize2;
                        long speed2;
                        long usecs2;
                        this.progressReporter.finishClass();
                        profiler.endContext(this.currentClassName);
                        currentAnalysisContext.clearClassBeingAnalyzed();
                        if (PROGRESS && (usecs2 = (System.nanoTime() - classStartNanoTime) / 1000L) > 15000L && (speed2 = usecs2 / (long)(classSize2 = currentAnalysisContext.getClassSize(classDescriptor))) > 15L) {
                            System.out.printf("  %6d usecs/byte  %6d msec  %6d bytes  %d pass %s%n", speed2, usecs2 / 1000L, classSize2, passCount, classDescriptor);
                        }
                        throw throwable;
                    }
                    if (!PROGRESS || (usecs = (System.nanoTime() - classStartNanoTime) / 1000L) <= 15000L || (speed = usecs / (long)(classSize = currentAnalysisContext.getClassSize(classDescriptor))) <= 15L) continue;
                    System.out.printf("  %6d usecs/byte  %6d msec  %6d bytes  %d pass %s%n", speed, usecs / 1000L, classSize, passCount, classDescriptor);
                }
                for (Detector2 detector2 : detectorList) {
                    detector2.finishPass();
                }
                this.progressReporter.finishPerClassAnalysis();
                ++passCount;
            }
        }
        finally {
            this.bugReporter.finish();
            this.bugReporter.reportQueuedErrors();
            profiler.end(this.getClass());
            if (PROGRESS) {
                System.out.println("Analysis completed");
            }
        }
    }

    private void notifyClassObservers(ClassDescriptor classDescriptor) {
        for (IClassObserver observer : this.classObserverList) {
            observer.observeClass(classDescriptor);
        }
    }

    private void logRecoverableException(ClassDescriptor classDescriptor, Detector2 detector, Throwable e) {
        this.bugReporter.logError("Exception analyzing " + classDescriptor.getDottedClassName() + " using detector " + detector.getDetectorClassName(), e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        ExecutorService service;
        if (!CheckBcel.check()) {
            System.exit(1);
        }
        if (MULTI_THREAD) {
            LOG.warn("Multi-thread analysis is still experimental!");
            service = Executors.newCachedThreadPool();
        } else {
            service = new CurrentThreadExecutorService();
        }
        try (FindBugs2 findBugs = new FindBugs2(service);){
            TextUICommandLine commandLine = new TextUICommandLine();
            FindBugs.processCommandLine(commandLine, args, findBugs);
            boolean justPrintConfiguration = commandLine.justPrintConfiguration();
            if (justPrintConfiguration || commandLine.justPrintVersion()) {
                Version.printVersion(justPrintConfiguration);
                return;
            }
            FindBugs.runMain(findBugs, commandLine);
        }
        finally {
            service.shutdown();
        }
    }

    @Override
    public void setAbridgedMessages(boolean xmlWithAbridgedMessages) {
        this.analysisOptions.abridgedMessages = xmlWithAbridgedMessages;
    }

    @Override
    public void setMergeSimilarWarnings(boolean mergeSimilarWarnings) {
        this.analysisOptions.mergeSimilarWarnings = mergeSimilarWarnings;
    }

    @Override
    public void setApplySuppression(boolean applySuppression) {
        this.analysisOptions.applySuppression = applySuppression;
    }

    @Override
    public void setRankThreshold(int rankThreshold) {
        this.rankThreshold = rankThreshold;
    }

    @Override
    public void finishSettings() {
        if (this.analysisOptions.applySuppression) {
            this.bugReporter = new FilterBugReporter(this.bugReporter, this.getProject().getSuppressionFilter(), false);
        }
    }

    @Override
    public void setBugReporterDecorators(Set<String> explicitlyEnabled, Set<String> explicitlyDisabled) {
        this.explicitlyEnabledBugReporterDecorators = explicitlyEnabled;
        this.explicitlyDisabledBugReporterDecorators = explicitlyDisabled;
    }

    @Override
    public void close() {
        this.dispose();
    }
}

