/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BugReporterObserver;
import edu.umd.cs.findbugs.ConfigurableBugReporter;
import edu.umd.cs.findbugs.PriorityAdjuster;
import edu.umd.cs.findbugs.ProjectStats;
import edu.umd.cs.findbugs.TextUIBugReporter;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;

public class BugReportDispatcher
implements ConfigurableBugReporter {
    @NonNull
    private final List<TextUIBugReporter> reporters;

    public BugReportDispatcher(Collection<TextUIBugReporter> reporters) {
        if (reporters == null || reporters.isEmpty()) {
            throw new IllegalArgumentException("No reporter provided");
        }
        this.reporters = new ArrayList<TextUIBugReporter>(reporters);
    }

    @Override
    public void setErrorVerbosity(int level) {
        this.forEach(reporter -> reporter.setErrorVerbosity(level));
    }

    @Override
    public void setPriorityThreshold(int threshold) {
        this.forEach(reporter -> reporter.setPriorityThreshold(threshold));
    }

    @Override
    public void setPriorityAdjuster(PriorityAdjuster priorityAdjuster) {
        throw new UnsupportedOperationException("Priority adjustment is not supported by " + String.valueOf(BugReportDispatcher.class));
    }

    @Override
    public void finish() {
        this.forEach(BugReporter::finish);
    }

    @Override
    public void reportQueuedErrors() {
        this.forEach(BugReporter::reportQueuedErrors);
    }

    @Override
    public void addObserver(BugReporterObserver observer) {
        this.forEach(reporter -> reporter.addObserver(observer));
    }

    @Override
    public ProjectStats getProjectStats() {
        return this.reporters.get(0).getProjectStats();
    }

    @Override
    public void reportBug(@NonNull BugInstance bugInstance) {
        this.forEach(reporter -> reporter.reportBug(bugInstance));
    }

    @Override
    @CheckForNull
    public BugCollection getBugCollection() {
        return this.reporters.get(0).getBugCollection();
    }

    @Override
    public void observeClass(ClassDescriptor classDescriptor) {
        this.forEach(reporter -> reporter.observeClass(classDescriptor));
    }

    @Override
    public void reportMissingClass(ClassNotFoundException ex) {
        this.forEach(reporter -> reporter.reportMissingClass(ex));
    }

    @Override
    public void reportMissingClass(ClassDescriptor classDescriptor) {
        this.forEach(reporter -> reporter.reportMissingClass(classDescriptor));
    }

    @Override
    public void logError(String message) {
        this.forEach(reporter -> reporter.logError(message));
    }

    @Override
    public void logError(String message, Throwable e) {
        this.forEach(reporter -> reporter.logError(message, e));
    }

    @Override
    public void reportSkippedAnalysis(MethodDescriptor method) {
        this.forEach(reporter -> reporter.reportSkippedAnalysis(method));
    }

    @Override
    public void setRankThreshold(int threshold) {
        this.forEach(reporter -> reporter.setRankThreshold(threshold));
    }

    @Override
    public void setUseLongBugCodes(boolean useLongBugCodes) {
        this.forEach(reporter -> reporter.setUseLongBugCodes(useLongBugCodes));
    }

    @Override
    public void setOutputStream(PrintStream outputStream) {
        this.forEach(reporter -> reporter.setOutputStream(outputStream));
    }

    private void forEach(Consumer<TextUIBugReporter> consumer) {
        List exceptions = this.reporters.stream().map(reporter -> {
            try {
                consumer.accept((TextUIBugReporter)reporter);
                return null;
            }
            catch (RuntimeException thrown) {
                return thrown;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (exceptions.isEmpty()) {
            return;
        }
        RuntimeException head = (RuntimeException)exceptions.get(0);
        for (int i = 1; i < exceptions.size(); ++i) {
            head.addSuppressed((Throwable)exceptions.get(i));
        }
        throw head;
    }
}

