/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.workflow;

import edu.umd.cs.findbugs.AnalysisError;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.ProjectStats;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.config.CommandLine;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dom4j.DocumentException;

public class UnionResults {
    public static SortedBugCollection union(SortedBugCollection origCollection, SortedBugCollection newCollection) {
        SortedBugCollection result = origCollection.duplicate();
        UnionResults.merge(null, result, newCollection);
        return result;
    }

    public static void merge(HashSet<String> hashes, SortedBugCollection into, SortedBugCollection from) {
        for (BugInstance bugInstance : from.getCollection()) {
            if (hashes != null && !hashes.add(bugInstance.getInstanceHash())) continue;
            into.add(bugInstance);
        }
        ProjectStats stats = into.getProjectStats();
        ProjectStats stats2 = from.getProjectStats();
        stats.addStats(stats2);
        Project project = into.getProject();
        Project project2 = from.getProject();
        project.add(project2);
        for (AnalysisError analysisError : from.getErrors()) {
            into.addError(analysisError);
        }
    }

    public static void main(String[] argv) throws IOException {
        FindBugs.setNoAnalysis();
        UnionResultsCommandLine commandLine = new UnionResultsCommandLine();
        int argCount = commandLine.parse(argv, 1, Integer.MAX_VALUE, "Usage: " + UnionResults.class.getName() + " [options] [<results1> <results2> ... <resultsn>] ");
        SortedBugCollection results = null;
        HashSet<String> hashes = new HashSet<String>();
        results = UnionResults.iterateArguments(Stream.of(argv).collect(Collectors.toList()), argCount, results, hashes);
        if (results == null) {
            System.err.println("No files successfully read");
            System.exit(1);
            return;
        }
        results.setWithMessages(commandLine.withMessages);
        if (commandLine.outputFile == null) {
            results.writeXML(System.out);
        } else {
            results.writeXML(commandLine.outputFile);
        }
    }

    private static SortedBugCollection iterateArguments(List<String> arguments, int argCount, SortedBugCollection results, HashSet<String> hashes) {
        for (int i = argCount; i < arguments.size(); ++i) {
            String fileName = arguments.get(i);
            try {
                SortedBugCollection more = new SortedBugCollection();
                if (fileName.endsWith(".txt")) {
                    List<String> wrappedArguments = UnionResults.readWrappedArguments(fileName);
                    if (results == null) {
                        results = more.createEmptyCollectionWithMetadata();
                    }
                    UnionResults.merge(hashes, results, UnionResults.iterateArguments(wrappedArguments, 0, results, hashes));
                    continue;
                }
                more.readXML(fileName);
                if (results == null) {
                    results = more.createEmptyCollectionWithMetadata();
                }
                UnionResults.merge(hashes, results, more);
                continue;
            }
            catch (IOException | DocumentException e) {
                System.err.println("Trouble reading/parsing " + fileName);
            }
        }
        return results;
    }

    private static List<String> readWrappedArguments(String fileName) throws IOException {
        ArrayList<String> wrappedArguments = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(Path.of(fileName, new String[0]), new OpenOption[0]), StandardCharsets.UTF_8));){
            String next;
            while ((next = reader.readLine()) != null) {
                wrappedArguments.add(next);
            }
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
        return wrappedArguments;
    }

    static {
        DetectorFactoryCollection.instance();
    }

    static class UnionResultsCommandLine
    extends CommandLine {
        public String outputFile;
        boolean withMessages;

        UnionResultsCommandLine() {
            this.addSwitch("-withMessages", "Generated XML should contain msgs for external processing");
            this.addOption("-output", "outputFile", "File in which to store combined results");
        }

        @Override
        protected void handleOption(String option, String optionExtraPart) throws IOException {
            if (!"-withMessages".equals(option)) {
                throw new IllegalArgumentException("Unknown option : " + option);
            }
            this.withMessages = true;
        }

        @Override
        protected void handleOptionWithArgument(String option, String argument) throws IOException {
            if (!"-output".equals(option)) {
                throw new IllegalArgumentException("Unknown option : " + option);
            }
            this.outputFile = argument;
        }
    }
}

