/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.workflow;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.PackageStats;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.util.Bag;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;

public class TreemapVisualization {
    HashSet<String> buggyPackages = new HashSet();
    HashSet<String> interiorPackages = new HashSet();
    Bag<String> goodCodeSize = new Bag(new TreeMap());
    Bag<String> goodCodeCount = new Bag(new TreeMap());

    public void addInteriorPackages(String packageName) {
        String p = TreemapVisualization.superpackage(packageName);
        if (!p.isEmpty()) {
            this.interiorPackages.add(p);
            this.addInteriorPackages(p);
        }
    }

    private static String superpackage(String packageName) {
        int i = packageName.lastIndexOf(46);
        if (i == -1) {
            return "";
        }
        return packageName.substring(0, i);
    }

    public boolean isInteriorPackage(String packageName) {
        return this.interiorPackages.contains(packageName);
    }

    public void cleanCode(String packageName, int loc, int classes) {
        String superpackage = TreemapVisualization.superpackage(packageName);
        if (this.buggyPackages.contains(superpackage) || this.interiorPackages.contains(superpackage) || superpackage.isEmpty()) {
            this.goodCodeCount.add(packageName, classes);
            this.goodCodeSize.add(packageName, loc);
            if (!superpackage.isEmpty()) {
                this.interiorPackages.add(superpackage);
            }
        } else {
            this.cleanCode(superpackage, loc, classes);
        }
    }

    public void generateTreeMap(BugCollection bugCollection) {
        for (PackageStats packageStats : bugCollection.getProjectStats().getPackageStats()) {
            if (packageStats.getTotalBugs() <= 0) continue;
            this.buggyPackages.add(packageStats.getPackageName());
            this.addInteriorPackages(packageStats.getPackageName());
        }
        for (PackageStats packageStats : bugCollection.getProjectStats().getPackageStats()) {
            if (packageStats.getTotalBugs() != 0) continue;
            this.cleanCode(packageStats.getPackageName(), packageStats.size(), packageStats.getClassStats().size());
        }
        System.out.println("LOC\tTypes\tH\tHM\tDensity");
        System.out.println("INTEGER\tINTEGER\tINTEGER\tINTEGER\tFLOAT");
        for (PackageStats packageStats : bugCollection.getProjectStats().getPackageStats()) {
            if (packageStats.getTotalBugs() <= 0) continue;
            int high = packageStats.getBugsAtPriority(1);
            int normal = packageStats.getBugsAtPriority(2);
            System.out.printf("%d\t%d\t%d\t%d\t%g\t\t%s", packageStats.size(), packageStats.getClassStats().size(), high, high + normal, (double)(high + normal) * 1000.0 / (double)packageStats.size(), packageStats.getPackageName().substring(11).replace('.', '\t'));
            if (this.isInteriorPackage(packageStats.getPackageName())) {
                System.out.print("\t*");
            }
            System.out.println();
        }
        for (Map.Entry entry : this.goodCodeSize.entrySet()) {
            System.out.printf("%d\t%d\t%d\t%d\t%g\t\t%s%n", entry.getValue(), this.goodCodeCount.getCount((String)entry.getKey()), 0, 0, 0.0, ((String)entry.getKey()).substring(11).replace('.', '\t'));
        }
    }

    public static void main(String[] args) throws Exception {
        FindBugs.setNoAnalysis();
        DetectorFactoryCollection.instance();
        SortedBugCollection bugCollection = new SortedBugCollection();
        int argCount = 0;
        if (argCount < args.length) {
            bugCollection.readXML(args[argCount++]);
        } else {
            bugCollection.readXML(System.in);
        }
        new TreemapVisualization().generateTreeMap(bugCollection);
    }
}

