/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.gui2.MainFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;

public class SplashFrame
extends JWindow {
    private static Thread animator;

    public SplashFrame() {
        super(new Frame());
        Viewer viewer;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.getImage(MainFrame.class.getResource("SplashBug1.png"));
        Image image2 = toolkit.getImage(MainFrame.class.getResource("SplashBug2B.png"));
        Image imageReverse = toolkit.getImage(MainFrame.class.getResource("SplashBug1reverse.png"));
        Image image2Reverse = toolkit.getImage(MainFrame.class.getResource("SplashBug2reverseB.png"));
        JLabel l = new JLabel(new ImageIcon(MainFrame.class.getResource("spotbugs.png")));
        JPanel p = new JPanel();
        Viewer bottom = viewer = new Viewer(image, image2, imageReverse, image2Reverse);
        p.setBackground(Color.white);
        bottom.setBackground(Color.white);
        p.add(l);
        this.getContentPane().add((Component)p, "Center");
        this.getContentPane().add((Component)bottom, "South");
        this.pack();
        Dimension labelSize = l.getPreferredSize();
        p.setPreferredSize(new Dimension(labelSize.width + 50, labelSize.height + 20));
        p.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        bottom.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        Dimension panelSize = p.getPreferredSize();
        bottom.setPreferredSize(new Dimension(panelSize.width, image.getHeight(null) + 2));
        this.setLocationRelativeTo(null);
        this.pack();
        viewer.animate();
    }

    public static void main(String[] args) {
        new SplashFrame().setVisible(true);
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (!b) {
            animator.interrupt();
        }
    }

    private static class Viewer
    extends JPanel {
        private Image image;
        private Image image2;
        private Image imageR;
        private Image image2R;
        boolean swap = false;
        boolean reverse = true;
        int callCount = 0;
        int xpos = 0;
        int ypos = 0;

        public Viewer(Image i1, Image i2, Image i1r, Image i2r) {
            this.image = i1;
            this.image2 = i2;
            this.imageR = i1r;
            this.image2R = i2r;
            MediaTracker mediaTracker = new MediaTracker(this);
            mediaTracker.addImage(this.image, 0);
            mediaTracker.addImage(this.image2, 1);
            mediaTracker.addImage(this.imageR, 2);
            mediaTracker.addImage(this.image2R, 3);
            try {
                mediaTracker.waitForID(0);
                mediaTracker.waitForID(1);
                mediaTracker.waitForID(2);
                mediaTracker.waitForID(3);
            }
            catch (InterruptedException ie) {
                System.err.println(ie);
                System.exit(1);
            }
            animator = new Thread(() -> {
                int deltaX = 1;
                while (true) {
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    ++this.callCount;
                    if (this.callCount == 10) {
                        this.swap = !this.swap;
                        this.callCount = 0;
                    }
                    this.xpos += deltaX;
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    if (this.xpos > this.getSize().width - this.image.getWidth(null)) {
                        deltaX = -1;
                        boolean bl = this.reverse = !this.reverse;
                    }
                    if (this.xpos < 0) {
                        deltaX = 1;
                        this.reverse = !this.reverse;
                    }
                    this.repaint();
                }
            }, "SpotBugs Splash screen thread");
            animator.setDaemon(true);
            animator.setPriority(1);
        }

        public void animate() {
            animator.start();
        }

        private Image imageToDraw() {
            if (this.swap) {
                if (!this.reverse) {
                    return this.image;
                }
                return this.imageR;
            }
            if (!this.reverse) {
                return this.image2;
            }
            return this.image2R;
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            graphics.drawImage(this.imageToDraw(), this.xpos, this.ypos, null);
        }
    }
}

