/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.util.ClassName;
import edu.umd.cs.findbugs.util.NestedAccessUtil;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantDynamic;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantInvokeDynamic;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Visitor;

public class ResolveAllReferences
extends PreorderVisitor
implements Detector {
    private final BugReporter bugReporter;
    Set<String> defined;

    public ResolveAllReferences(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    private void compute() {
        if (this.defined == null) {
            this.defined = new HashSet<String>();
            Subtypes2 subtypes2 = AnalysisContext.currentAnalysisContext().getSubtypes2();
            Collection<XClass> allClasses = subtypes2.getXClassCollection();
            IAnalysisCache analysisCache = Global.getAnalysisCache();
            for (XClass c : allClasses) {
                try {
                    JavaClass jclass = analysisCache.getClassAnalysis(JavaClass.class, c.getClassDescriptor());
                    this.addAllDefinitions(jclass);
                }
                catch (CheckedAnalysisException e) {
                    this.bugReporter.reportMissingClass(c.getClassDescriptor(), e);
                }
            }
        }
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        classContext.getJavaClass().accept((Visitor)this);
    }

    @Override
    public void report() {
    }

    public void addAllDefinitions(JavaClass obj) {
        String name;
        String className2 = obj.getClassName();
        boolean addPrivateFields = NestedAccessUtil.hasNest(obj);
        this.defined.add(className2);
        for (Method method : obj.getMethods()) {
            if (method.isPrivate() && !addPrivateFields) continue;
            name = this.getMemberName(obj, className2, method.getNameIndex(), method.getSignatureIndex());
            this.defined.add(name);
        }
        for (Method method : obj.getFields()) {
            if (method.isPrivate() && !addPrivateFields) continue;
            name = this.getMemberName(obj, className2, method.getNameIndex(), method.getSignatureIndex());
            this.defined.add(name);
        }
    }

    private String getClassName(JavaClass c, int classIndex) {
        String name = c.getConstantPool().getConstantString(classIndex, (byte)7);
        return ClassName.toDottedClassName(ClassName.extractClassName(name));
    }

    private String getMemberName(JavaClass c, String className, int memberNameIndex, int signatureIndex) {
        return className + "." + ((ConstantUtf8)c.getConstantPool().getConstant(memberNameIndex, (byte)1)).getBytes() + " : " + ((ConstantUtf8)c.getConstantPool().getConstant(signatureIndex, (byte)1)).getBytes();
    }

    private String getMemberName(String className, String memberName, String signature) {
        return ClassName.toDottedClassName(className) + "." + memberName + " : " + signature;
    }

    private boolean find(JavaClass target, String name, String signature) throws ClassNotFoundException {
        if (target == null) {
            return false;
        }
        String ref = this.getMemberName(target.getClassName(), name, signature);
        if (this.defined.contains(ref)) {
            return true;
        }
        if (this.find(target.getSuperClass(), name, signature)) {
            return true;
        }
        for (JavaClass i : target.getInterfaces()) {
            if (!this.find(i, name, signature)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visit(JavaClass obj) {
        this.compute();
        ConstantPool cp = obj.getConstantPool();
        Constant[] constants = cp.getConstantPool();
        for (int i = 0; i < constants.length; ++i) {
            ConstantCP co2;
            String className;
            Constant co = constants[i];
            if (co instanceof ConstantDouble || co instanceof ConstantLong) {
                ++i;
            }
            if (co instanceof ConstantClass) {
                String ref = this.getClassName(obj, i);
                if (!ref.startsWith("java") && !ref.startsWith("org.w3c.dom") || this.defined.contains(ref)) continue;
                this.bugReporter.reportBug(new BugInstance(this, "VR_UNRESOLVABLE_REFERENCE", 2).addClass(obj).addString(ref));
                continue;
            }
            if (co instanceof ConstantFieldref || co instanceof ConstantInvokeDynamic || co instanceof ConstantDynamic || !(co instanceof ConstantCP) || (className = this.getClassName(obj, (co2 = (ConstantCP)co).getClassIndex())).equals(obj.getClassName()) || !this.defined.contains(className)) continue;
            ConstantNameAndType nt = (ConstantNameAndType)cp.getConstant(co2.getNameAndTypeIndex());
            String name = ((ConstantUtf8)obj.getConstantPool().getConstant(nt.getNameIndex(), (byte)1)).getBytes();
            String signature = ((ConstantUtf8)obj.getConstantPool().getConstant(nt.getSignatureIndex(), (byte)1)).getBytes();
            try {
                JavaClass target = Repository.lookupClass((String)className);
                if (this.find(target, name, signature)) continue;
                this.bugReporter.reportBug(new BugInstance(this, "VR_UNRESOLVABLE_REFERENCE", 2).addClass(obj).addString(this.getMemberName(target.getClassName(), name, signature)));
                continue;
            }
            catch (ClassNotFoundException e) {
                this.bugReporter.reportMissingClass(e);
            }
        }
    }
}

