/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser.violations;

import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.parser.violations.AbstractViolationAdapter;
import edu.hm.hafner.analysis.util.IntegerParser;
import edu.hm.hafner.util.LineRange;
import edu.hm.hafner.util.LineRangeList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.CPPCheckParser;

public class CppCheckAdapter
extends AbstractViolationAdapter {
    private static final long serialVersionUID = 2244442395053328008L;
    private static final String ORDER_KEY = "order";

    CPPCheckParser createParser() {
        return new CPPCheckParser();
    }

    @Override
    Report convertToReport(Set<Violation> violations) {
        try (IssueBuilder issueBuilder = new IssueBuilder();){
            Map<String, List<Violation>> violationsPerGroup = violations.stream().collect(Collectors.groupingBy(Violation::getGroup));
            Report report = new Report();
            for (List<Violation> group : violationsPerGroup.values()) {
                List<Violation> sortedGroup = this.sortByInsertionOrder(group);
                this.updateIssueBuilder(sortedGroup.get(0), issueBuilder);
                LineRangeList lineRanges = new LineRangeList();
                for (int i = 1; i < sortedGroup.size(); ++i) {
                    lineRanges.add(new LineRange(sortedGroup.get(i).getStartLine().intValue()));
                }
                issueBuilder.setLineRanges(lineRanges);
                report.add(issueBuilder.buildAndClean());
            }
            Report report2 = report;
            return report2;
        }
    }

    private List<Violation> sortByInsertionOrder(List<Violation> group) {
        return group.stream().sorted(Comparator.comparingInt(this::getOrder)).toList();
    }

    private int getOrder(Violation violation) {
        try {
            return IntegerParser.parseInt(violation.getSpecifics().getOrDefault(ORDER_KEY, "0"));
        }
        catch (NumberFormatException e) {
            return Integer.MAX_VALUE;
        }
    }
}

