/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class SimulinkCheckParser
extends IssueParser {
    private static final long serialVersionUID = -8099258658775128275L;
    private static final String WARNING = "div.WarningCheck";
    private static final String FAILED = "div.FailedCheck";
    private static final String NOT_RUN = "div.NotRunCheck";
    private static final String INCOMPLETE = "div.IncompleteCheck";
    private static final String EMPTY_BASE_URI = "";
    private static final String REPORT_CONTENT = "div.ReportContent";
    private static final String MODEL_NAME_SELECTOR = "b:contains(Model Advisor Report - ) > font";
    private static final Pattern TEXT_PATTERN = Pattern.compile("^(SW[0-9]*-[0-9]*)(\\W*)(.*)");
    private static final String SW_PREFIX = "SW";

    /*
     * Exception decompiling
     */
    @Override
    public Report parseReport(ReaderFactory readerFactory) throws ParsingException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void parseIssues(Report report, Document document, IssueBuilder issueBuilder, String system, String check) {
        this.setSeverity(check, issueBuilder);
        for (Element element : document.select(check)) {
            Elements headings = element.select("span.CheckHeading");
            Element heading = headings.first();
            if (heading == null) continue;
            SimulinkCheckParser.parseHeading(report, issueBuilder, system, element, headings, heading.id());
        }
    }

    private static void parseHeading(Report report, IssueBuilder issueBuilder, String system, Element element, Elements headings, String headingElement) {
        String[] headingSplit = headingElement.split("\\.");
        if (headingSplit.length > 0) {
            String issueTxt = headings.text();
            Matcher textMatcher = TEXT_PATTERN.matcher(issueTxt);
            if (textMatcher.matches()) {
                issueBuilder.setModuleName(textMatcher.group(1) + "." + headingSplit[headingSplit.length - 1]);
                issueBuilder.setDescription(textMatcher.group(3));
            } else {
                Element parent = element.parent();
                if (parent != null) {
                    SimulinkCheckParser.parseParent(issueBuilder, headingSplit, issueTxt, parent);
                }
            }
            issueBuilder.setFileName(system);
            report.add(issueBuilder.build());
        }
    }

    private static void parseParent(IssueBuilder issueBuilder, String[] headingSplit, String issueTxt, Element parent) {
        String parentId = parent.id();
        int prefix = parentId.indexOf(SW_PREFIX);
        if (prefix >= 0) {
            issueBuilder.setModuleName(parentId.substring(prefix) + "." + headingSplit[headingSplit.length - 1]);
        } else {
            issueBuilder.setModuleName(headingSplit[headingSplit.length - 1] + "." + headingSplit[headingSplit.length - 2]);
        }
        issueBuilder.setDescription(issueTxt);
    }

    private void setSeverity(String check, IssueBuilder issueBuilder) {
        if (FAILED.equals(check)) {
            issueBuilder.setSeverity(Severity.ERROR).setCategory("Failed");
        } else if (NOT_RUN.equals(check)) {
            issueBuilder.setSeverity(Severity.WARNING_HIGH).setCategory("Not Run");
        } else if (INCOMPLETE.equals(check)) {
            issueBuilder.setSeverity(Severity.WARNING_LOW).setCategory("Incomplete");
        } else {
            issueBuilder.setSeverity(Severity.WARNING_NORMAL).setCategory("Warning");
        }
    }
}

