/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.parser.JsonIssueParser;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import org.json.JSONArray;
import org.json.JSONObject;

public class OwaspDependencyCheckParser
extends JsonIssueParser {
    private static final long serialVersionUID = -1369431674771459756L;
    private static final String NDIST_NVD_DETAIL_URL_TEMPLATE = "https://nvd.nist.gov/vuln/detail/%1$s";
    private static final String LINK_TEMPLATE = "<a href=\"%1$s\">%1$s</a>".formatted("https://nvd.nist.gov/vuln/detail/%1$s");
    private static final String DEPENDENCIES = "dependencies";
    private static final String VULNERABILITIES = "vulnerabilities";
    private static final String SEVERITY = "severity";
    private static final String NAME = "name";
    private static final String CVSSV2 = "cvssv2";
    private static final String CVSSV3 = "cvssv3";
    private static final String ACCESS_VECTOR = "accessVector";
    private static final String ATTACK_VECTOR = "attackVector";
    private static final String DESCRIPTION = "description";

    @Override
    protected void parseJsonObject(Report report, JSONObject jsonReport, IssueBuilder issueBuilder) {
        JSONArray dependencies = jsonReport.getJSONArray(DEPENDENCIES);
        for (int i = 0; i < dependencies.length(); ++i) {
            JSONObject dependency = dependencies.getJSONObject(i);
            if (!dependency.has(VULNERABILITIES)) continue;
            issueBuilder.setFileName(dependency.getString("fileName"));
            JSONArray vulnerabilities = dependency.getJSONArray(VULNERABILITIES);
            for (int j = 0; j < vulnerabilities.length(); ++j) {
                JSONObject vulnerability = vulnerabilities.getJSONObject(j);
                report.add(this.createIssueFromVulnerability(vulnerability, issueBuilder));
            }
        }
    }

    private Issue createIssueFromVulnerability(JSONObject vulnerability, IssueBuilder issueBuilder) {
        String name = vulnerability.getString(NAME);
        return issueBuilder.setSeverity(this.mapSeverity(vulnerability.getString(SEVERITY))).setCategory(this.determineCategory(vulnerability)).setType(name).setMessage(vulnerability.getString(DESCRIPTION)).setDescription(LINK_TEMPLATE.formatted(name)).build();
    }

    @CheckForNull
    private String determineCategory(JSONObject vulnerability) {
        String category;
        JSONObject cvssv3 = vulnerability.optJSONObject(CVSSV3);
        if (cvssv3 != null && (category = cvssv3.optString(ATTACK_VECTOR, null)) != null) {
            return category;
        }
        JSONObject cvssv2 = vulnerability.optJSONObject(CVSSV2);
        if (cvssv2 != null) {
            return cvssv2.optString(ACCESS_VECTOR, null);
        }
        return null;
    }

    private Severity mapSeverity(String severity) {
        switch (severity) {
            case "LOW": {
                return Severity.WARNING_LOW;
            }
            case "MEDIUM": {
                return Severity.WARNING_NORMAL;
            }
            case "CRITICAL": {
                return Severity.ERROR;
            }
        }
        return Severity.WARNING_HIGH;
    }
}

