/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.LookaheadParser;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.parser.Gcc4CompilerParser;
import edu.hm.hafner.util.LookaheadStream;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.util.Optional;
import java.util.regex.Matcher;

public class DoxygenParser
extends LookaheadParser {
    private static final long serialVersionUID = 8760302999081711502L;
    private static final String DOXYGEN_WARNING_PATTERN = "^(?:.*\\[[^]]*\\])?\\s*(?:(?:(.+?):(\\d+):|(.+?)\\((\\d+)\\):)?(?:(\\d+):)?)? ?([wW]arning|[Ee]rror): (.*)$";

    public DoxygenParser() {
        super(DOXYGEN_WARNING_PATTERN);
    }

    @Override
    protected boolean isLineInteresting(String line) {
        return (line.contains("arning") || line.contains("rror")) && !line.contains("[javac]");
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, LookaheadStream lookahead, IssueBuilder builder) {
        StringBuilder message = new StringBuilder(matcher.group(7));
        if (matcher.group(1) != null || matcher.group(2) != null) {
            fileName = this.cleanupFileName(matcher.group(1));
            builder.setFileName(fileName);
            builder.setLineStart(matcher.group(2));
        } else {
            fileName = this.cleanupFileName(matcher.group(3));
            builder.setFileName(fileName);
            builder.setLineStart(matcher.group(4));
        }
        while (lookahead.hasNext() && Gcc4CompilerParser.isMessageContinuation(lookahead)) {
            message.append('\n');
            message.append(lookahead.next());
        }
        return builder.setColumnStart(matcher.group(5)).setMessage(message.toString()).setSeverity(Severity.guessFromString(matcher.group(6))).buildOptional();
    }

    private String cleanupFileName(String fileName) {
        if (fileName == null || !fileName.contains("Generating")) {
            return fileName;
        }
        String extracted = this.extractWindowsPath(fileName);
        if (extracted != null) {
            return extracted;
        }
        return this.extractUnixPath(fileName);
    }

    @CheckForNull
    private String extractWindowsPath(String fileName) {
        char driveLetter;
        int windowsPathIndex = fileName.indexOf(":/");
        if (windowsPathIndex == -1) {
            windowsPathIndex = fileName.indexOf(":\\");
        }
        if (windowsPathIndex > 0 && windowsPathIndex < fileName.length() - 1 && Character.isLetter(driveLetter = fileName.charAt(windowsPathIndex - 1))) {
            return fileName.substring(windowsPathIndex - 1);
        }
        return null;
    }

    private String extractUnixPath(String fileName) {
        int generatingIndex = fileName.indexOf("Generating");
        if (generatingIndex < 0) {
            return fileName;
        }
        int pathStart = fileName.indexOf(47, generatingIndex);
        int unixPathIndex = fileName.lastIndexOf(47);
        if (pathStart > 0 && pathStart < unixPathIndex) {
            return fileName.substring(pathStart);
        }
        return fileName;
    }
}

