/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types.internal.infer;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collector;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.TypeOps;
import net.sourceforge.pmd.util.OptionalBool;
import org.apache.commons.lang3.NotImplementedException;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class OverloadSet<T> {
    private final List<T> overloads = new ArrayList<T>();

    OverloadSet() {
    }

    void add(T sig) {
        ListIterator<T> iterator = this.overloads.listIterator();
        while (iterator.hasNext()) {
            T existing = iterator.next();
            switch (this.shouldTakePrecedence(existing, sig)) {
                case YES: {
                    return;
                }
                case NO: {
                    iterator.remove();
                    break;
                }
            }
        }
        this.overloads.add(sig);
    }

    protected abstract OptionalBool shouldTakePrecedence(T var1, T var2);

    List<T> getOverloadsMutable() {
        return this.overloads;
    }

    boolean nonEmpty() {
        return !this.overloads.isEmpty();
    }

    public static Collector<JMethodSig, ?, List<JMethodSig>> collectMostSpecific(JTypeMirror commonSubtype) {
        return Collector.of(() -> new ContextIndependentSet(commonSubtype), OverloadSet::add, (left, right) -> {
            throw new NotImplementedException("Cannot use this in a parallel stream");
        }, o -> Collections.unmodifiableList(o.getOverloadsMutable()), new Collector.Characteristics[0]);
    }

    static OptionalBool shouldAlwaysTakePrecedence(@NonNull JMethodSig m1, @NonNull JMethodSig m2, @NonNull JTypeMirror commonSubtype) {
        if (TypeOps.overrides(m1, m2, commonSubtype)) {
            return OptionalBool.YES;
        }
        if (TypeOps.overrides(m2, m1, commonSubtype)) {
            return OptionalBool.NO;
        }
        if (m1.isAbstract() ^ m2.isAbstract()) {
            return OptionalBool.definitely((!m1.isAbstract() ? 1 : 0) != 0);
        }
        if (m1.isAbstract() && m2.isAbstract()) {
            boolean m1InClass = m1.getSymbol().getEnclosingClass().isClass();
            boolean m2Class = m2.getSymbol().getEnclosingClass().isClass();
            return m1InClass && m2Class ? OptionalBool.UNKNOWN : OptionalBool.definitely((boolean)m1InClass);
        }
        if (Modifier.isPrivate(m1.getModifiers() | m2.getModifiers()) && commonSubtype instanceof JClassType) {
            return OverloadSet.shadows(m1, m2, (JClassType)commonSubtype);
        }
        return OptionalBool.UNKNOWN;
    }

    static OptionalBool shadows(JMethodSig m1, JMethodSig m2, JClassType site) {
        JClassSymbol c1 = m1.getSymbol().getEnclosingClass();
        JClassSymbol c2 = m2.getSymbol().getEnclosingClass();
        int height = 0;
        int c1Height = -1;
        int c2Height = -1;
        JClassSymbol c = site.getSymbol();
        while (c != null) {
            if (c.equals(c1)) {
                c1Height = height;
            }
            if (c.equals(c2)) {
                c2Height = height;
            }
            c = c.getEnclosingClass();
            ++height;
        }
        if (c1Height < 0 || c2Height < 0 || c1Height == c2Height) {
            return OptionalBool.UNKNOWN;
        }
        return OptionalBool.definitely((c1Height < c2Height ? 1 : 0) != 0);
    }

    static final class ContextIndependentSet
    extends OverloadSet<JMethodSig> {
        private final JTypeMirror viewingSite;
        private String name;

        ContextIndependentSet(JTypeMirror viewingSite) {
            this.viewingSite = viewingSite;
        }

        @Override
        protected OptionalBool shouldTakePrecedence(JMethodSig m1, JMethodSig m2) {
            return TypeOps.areOverrideEquivalent(m1, m2) ? ContextIndependentSet.shouldAlwaysTakePrecedence(m1, m2, this.viewingSite) : OptionalBool.UNKNOWN;
        }

        @Override
        void add(JMethodSig sig) {
            if (this.name == null) {
                this.name = sig.getName();
            }
            assert (sig.getName().equals(this.name)) : "Not the right name!";
            assert (!sig.isConstructor()) : "Constructors they cannot override each other";
            super.add(sig);
        }
    }
}

