/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.xpath.internal;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.GenericTreeInfo;
import net.sf.saxon.om.NodeInfo;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.RootNode;
import net.sourceforge.pmd.lang.rule.xpath.internal.AstDocumentNode;
import net.sourceforge.pmd.lang.rule.xpath.internal.AstElementNode;
import net.sourceforge.pmd.lang.rule.xpath.internal.DeprecatedAttrLogger;
import org.apache.commons.lang3.mutable.MutableInt;

public final class AstTreeInfo
extends GenericTreeInfo {
    private DeprecatedAttrLogger logger;
    private final Map<Node, AstElementNode> wrapperCache = new LinkedHashMap<Node, AstElementNode>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 1024;
        }
    };

    public AstTreeInfo(RootNode node, Configuration configuration) {
        super(configuration);
        MutableInt idGenerator = new MutableInt(1);
        this.setRootNode((NodeInfo)new AstDocumentNode(this, idGenerator, node, configuration));
    }

    public AstElementNode findWrapperFor(Node node) {
        AstElementNode element = this.wrapperCache.get(node);
        if (element == null) {
            element = this.findWrapperImpl(node);
            this.wrapperCache.put(node, element);
            assert (element.getUnderlyingNode() == node) : "Incorrect wrapper " + element + " for " + node;
        }
        return element;
    }

    private AstElementNode findWrapperImpl(Node node) {
        AstElementNode cur = this.getRootNode().getRootElement();
        ArrayList<Node> ancestors = new ArrayList<Node>();
        for (Node node2 : node.ancestorsOrSelf()) {
            AstElementNode wrappedAncestor = this.wrapperCache.get(node2);
            ancestors.add(node2);
            if (wrappedAncestor == null) continue;
            cur = wrappedAncestor;
            break;
        }
        for (int i = ancestors.size() - 2; i >= 0; --i) {
            Node node3 = (Node)ancestors.get(i);
            int idx = node3.getIndexInParent();
            if (idx >= cur.getChildren().size()) {
                throw new IllegalArgumentException("Node is not part of this tree " + node);
            }
            cur = cur.getChildren().get(idx);
            this.wrapperCache.put(node3, cur);
        }
        if (cur.getUnderlyingNode() != node) {
            throw new IllegalArgumentException("Node is not part of this tree " + node);
        }
        return cur;
    }

    public AstDocumentNode getRootNode() {
        return (AstDocumentNode)super.getRootNode();
    }

    public void setAttrCtx(DeprecatedAttrLogger attrCtx) {
        this.logger = attrCtx;
    }

    public DeprecatedAttrLogger getLogger() {
        return this.logger == null ? DeprecatedAttrLogger.noop() : this.logger;
    }
}

