/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast.internal;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.ast.internal.IteratorBasedNStream;
import net.sourceforge.pmd.lang.ast.internal.StreamImpl;
import net.sourceforge.pmd.util.AssertionUtil;
import net.sourceforge.pmd.util.IteratorUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class SingletonNodeStream<T extends Node>
extends IteratorBasedNStream<T>
implements NodeStream.DescendantNodeStream<T> {
    private final T node;

    SingletonNodeStream(@NonNull T node) {
        assert (node != null) : "null node!";
        this.node = node;
    }

    @Override
    public Stream<T> toStream() {
        return Stream.of(this.node);
    }

    @Override
    public List<T> toList() {
        return Collections.singletonList(this.node);
    }

    @Override
    public <R> List<R> toList(Function<? super T, ? extends R> mapper) {
        return Collections.singletonList(mapper.apply(this.node));
    }

    @Override
    public int count() {
        return 1;
    }

    @Override
    public T first() {
        return this.node;
    }

    @Override
    public T last() {
        return this.node;
    }

    @Override
    public boolean nonEmpty() {
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        return IteratorUtil.singletonIterator(this.node);
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        action.accept(this.node);
    }

    @Override
    public NodeStream<T> filter(Predicate<? super T> predicate) {
        return predicate.test(this.node) ? this : NodeStream.empty();
    }

    @Override
    public NodeStream<T> drop(int n) {
        AssertionUtil.requireNonNegative("n", n);
        return n == 0 ? this : NodeStream.empty();
    }

    @Override
    public NodeStream<T> take(int maxSize) {
        AssertionUtil.requireNonNegative("maxSize", maxSize);
        return maxSize >= 1 ? this : NodeStream.empty();
    }

    @Override
    public NodeStream<T> cached() {
        return this;
    }

    @Override
    public NodeStream<T> distinct() {
        return this;
    }

    @Override
    public NodeStream<T> takeWhile(Predicate<? super T> predicate) {
        return this.filter(predicate);
    }

    @Override
    public <R extends Node> NodeStream<@NonNull R> map(Function<? super T, ? extends @Nullable R> mapper) {
        return NodeStream.of((Node)mapper.apply(this.node));
    }

    @Override
    public <R extends Node> NodeStream<R> flatMap(Function<? super T, ? extends NodeStream<? extends R>> mapper) {
        return mapper.apply(this.node);
    }

    @Override
    public boolean any(Predicate<? super T> predicate) {
        return predicate.test(this.node);
    }

    @Override
    public boolean all(Predicate<? super T> predicate) {
        return predicate.test(this.node);
    }

    @Override
    public boolean none(Predicate<? super T> predicate) {
        return !predicate.test(this.node);
    }

    @Override
    public NodeStream<Node> children() {
        return StreamImpl.children(this.node);
    }

    @Override
    public <R extends Node> NodeStream<R> children(Class<? extends R> rClass) {
        return StreamImpl.children(this.node, rClass);
    }

    @Override
    public <R extends Node> NodeStream<R> firstChild(Class<? extends R> rClass) {
        return NodeStream.of(this.node.firstChild(rClass));
    }

    @Override
    public NodeStream<Node> parents() {
        return NodeStream.of(this.node.getParent());
    }

    @Override
    public NodeStream<Node> ancestors() {
        return StreamImpl.ancestors(this.node);
    }

    @Override
    public <R extends Node> NodeStream<R> ancestors(Class<? extends R> rClass) {
        return StreamImpl.ancestors(this.node, rClass);
    }

    @Override
    public NodeStream<Node> ancestorsOrSelf() {
        return StreamImpl.ancestorsOrSelf(this.node);
    }

    @Override
    public NodeStream.DescendantNodeStream<Node> descendants() {
        return StreamImpl.descendants(this.node);
    }

    @Override
    public <R extends Node> NodeStream.DescendantNodeStream<R> descendants(Class<? extends R> rClass) {
        return StreamImpl.descendants(this.node, rClass);
    }

    @Override
    public NodeStream.DescendantNodeStream<Node> descendantsOrSelf() {
        return StreamImpl.descendantsOrSelf(this.node);
    }

    @Override
    public NodeStream<Node> followingSiblings() {
        return StreamImpl.followingSiblings(this.node);
    }

    @Override
    public NodeStream<Node> precedingSiblings() {
        return StreamImpl.precedingSiblings(this.node);
    }

    @Override
    public NodeStream.DescendantNodeStream<T> crossFindBoundaries(boolean cross) {
        return this;
    }
}

