/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PMDVersion {
    private static final Logger LOG = LoggerFactory.getLogger(PMDVersion.class);
    public static final String VERSION;
    private static final String RELEASE_TIMESTAMP;
    private static final String GIT_COMMIT_ID;
    private static final String GIT_COMMIT_TIME;
    private static final String UNKNOWN = "unknown";

    private PMDVersion() {
        throw new AssertionError((Object)"Can't instantiate utility classes");
    }

    public static String getNextMajorRelease() {
        if (PMDVersion.isUnknown()) {
            return UNKNOWN;
        }
        int major = Integer.parseInt(VERSION.split("\\.")[0]);
        return major + 1 + ".0.0";
    }

    public static boolean isUnknown() {
        return UNKNOWN.equals(VERSION);
    }

    public static boolean isSnapshot() {
        return VERSION.endsWith("-SNAPSHOT");
    }

    public static String getFullVersionName() {
        if (PMDVersion.isSnapshot()) {
            return "PMD " + VERSION + " (" + GIT_COMMIT_ID + ", " + GIT_COMMIT_TIME + ")";
        }
        return "PMD " + VERSION + " (" + GIT_COMMIT_ID + ", " + RELEASE_TIMESTAMP + ")";
    }

    static {
        String pmdVersion = UNKNOWN;
        String releaseTimestamp = UNKNOWN;
        String gitCommitId = UNKNOWN;
        String gitCommitTime = UNKNOWN;
        try (InputStream stream = PMDVersion.class.getResourceAsStream("pmd-core-version.properties");){
            if (stream != null) {
                Properties properties = new Properties();
                properties.load(stream);
                pmdVersion = properties.getProperty("version");
                releaseTimestamp = properties.getProperty("releaseTimestamp");
                gitCommitId = properties.getProperty("gitCommitId");
                gitCommitTime = properties.getProperty("gitCommitTime");
            }
        }
        catch (IOException e) {
            LOG.debug("Couldn't determine version of PMD", (Throwable)e);
        }
        VERSION = pmdVersion;
        RELEASE_TIMESTAMP = releaseTimestamp;
        GIT_COMMIT_ID = gitCommitId;
        GIT_COMMIT_TIME = gitCommitTime;
    }
}

